/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutIndexTemplateAction
extends AcknowledgedTransportMasterNodeAction<PutIndexTemplateRequest> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("indices:admin/template/put");
    private static final Logger logger = LogManager.getLogger(TransportPutIndexTemplateAction.class);
    private final MetadataIndexTemplateService indexTemplateService;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public TransportPutIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexScopedSettings indexScopedSettings) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, PutIndexTemplateRequest::new, indexNameExpressionResolver, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexTemplateService = indexTemplateService;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected ClusterBlockException checkBlock(PutIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, final PutIndexTemplateRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws IOException {
        String cause = request.cause();
        if (cause.length() == 0) {
            cause = "api";
        }
        Settings.Builder templateSettingsBuilder = Settings.builder();
        templateSettingsBuilder.put(request.settings()).normalizePrefix("index.");
        this.indexScopedSettings.validate(templateSettingsBuilder.build(), true);
        this.indexTemplateService.putTemplate(new MetadataIndexTemplateService.PutRequest(cause, request.name()).patterns(request.patterns()).order(request.order()).settings(templateSettingsBuilder.build()).mappings(request.mappings() == null ? null : new CompressedXContent(request.mappings())).aliases(request.aliases()).create(request.create()).version(request.version()), request.masterNodeTimeout(), new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug(() -> "failed to put template [" + request.name() + "]", (Throwable)e);
                listener.onFailure(e);
            }
        });
    }
}

