/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.resolve;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class ResolveClusterActionRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpen();
    private String[] names;
    private boolean localIndicesRequested = false;
    private IndicesOptions indicesOptions;

    public ResolveClusterActionRequest(String[] names) {
        this(names, DEFAULT_INDICES_OPTIONS);
    }

    public ResolveClusterActionRequest(String[] names, IndicesOptions indicesOptions) {
        this.names = names;
        this.localIndicesRequested = this.localIndicesPresent(names);
        this.indicesOptions = indicesOptions;
    }

    public ResolveClusterActionRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_13_0)) {
            throw new UnsupportedOperationException("ResolveClusterAction requires at least version " + TransportVersions.V_8_13_0.toReleaseVersion() + " but was " + in.getTransportVersion().toReleaseVersion());
        }
        this.names = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.localIndicesRequested = this.localIndicesPresent(this.names);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().before(TransportVersions.V_8_13_0)) {
            throw new UnsupportedOperationException("ResolveClusterAction requires at least version " + TransportVersions.V_8_13_0.toReleaseVersion() + " but was " + out.getTransportVersion().toReleaseVersion());
        }
        out.writeStringArray(this.names);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.names == null || this.names.length == 0) {
            validationException = ValidateActions.addValidationError("no index expressions specified", validationException);
        }
        return validationException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolveClusterActionRequest request = (ResolveClusterActionRequest)o;
        return Arrays.equals(this.names, request.names) && this.indicesOptions.equals(request.indicesOptions());
    }

    public int hashCode() {
        int result = Objects.hash(this.indicesOptions);
        result = 31 * result + Arrays.hashCode(this.names);
        return result;
    }

    @Override
    public String[] indices() {
        return this.names;
    }

    public boolean isLocalIndicesRequested() {
        return this.localIndicesRequested;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    protected IndicesRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public IndicesRequest indices(String ... indices) {
        this.names = indices;
        return this;
    }

    @Override
    public boolean allowsRemoteIndices() {
        return true;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return "resolve/cluster for " + Arrays.toString(ResolveClusterActionRequest.this.indices());
            }
        };
    }

    boolean localIndicesPresent(String[] indices) {
        for (String index : indices) {
            String indexExpression = IndexNameExpressionResolver.resolveDateMathExpression(index);
            if (indexExpression.indexOf(58) >= 0) continue;
            return true;
        }
        return false;
    }
}

