/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.ListenableActionFuture;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.RemovedTaskListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportListTasksAction
extends TransportTasksAction<Task, ListTasksRequest, ListTasksResponse, TaskInfo> {
    public static final ActionType<ListTasksResponse> TYPE = new ActionType("cluster:monitor/tasks/lists");
    private static final TimeValue DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT = TimeValue.timeValueSeconds((long)30L);

    public static long waitForCompletionTimeout(TimeValue timeout) {
        if (timeout == null) {
            timeout = DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT;
        }
        return System.nanoTime() + timeout.nanos();
    }

    @Inject
    public TransportListTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(TYPE.name(), clusterService, transportService, actionFilters, ListTasksRequest::new, TaskInfo::from, transportService.getThreadPool().executor("management"));
    }

    @Override
    protected ListTasksResponse newResponse(ListTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    @Override
    protected void taskOperation(CancellableTask actionTask, ListTasksRequest request, Task task, ActionListener<TaskInfo> listener) {
        listener.onResponse(task.taskInfo(this.clusterService.localNode().getId(), request.getDetailed()));
    }

    @Override
    protected void doExecute(Task task, ListTasksRequest request, ActionListener<ListTasksResponse> listener) {
        assert (task instanceof CancellableTask);
        super.doExecute(task, request, listener);
    }

    @Override
    protected void processTasks(CancellableTask nodeTask, ListTasksRequest request, ActionListener<List<Task>> nodeOperation) {
        if (request.getWaitForCompletion()) {
            ListenableActionFuture future = new ListenableActionFuture();
            ArrayList<Task> processedTasks = new ArrayList<Task>();
            Set removedTasks = ConcurrentCollections.newConcurrentSet();
            Set matchedTasks = ConcurrentCollections.newConcurrentSet();
            AbstractRefCounted removalRefs = AbstractRefCounted.of(() -> {
                matchedTasks.removeAll(removedTasks);
                removedTasks.clear();
                if (matchedTasks.isEmpty()) {
                    future.onResponse(processedTasks);
                }
            });
            AtomicBoolean collectionComplete = new AtomicBoolean();
            RemovedTaskListener removedTaskListener = arg_0 -> TransportListTasksAction.lambda$processTasks$1(collectionComplete, (RefCounted)removalRefs, removedTasks, matchedTasks, future, processedTasks, arg_0);
            this.taskManager.registerRemovedTaskListener(removedTaskListener);
            ActionListener allMatchedTasksRemovedListener = ActionListener.runBefore(nodeOperation, () -> this.taskManager.unregisterRemovedTaskListener(removedTaskListener));
            try {
                for (Task task : this.processTasks(request)) {
                    if (!task.getAction().startsWith(TYPE.name())) {
                        matchedTasks.add(task);
                    }
                    processedTasks.add(task);
                }
            }
            catch (Exception e) {
                allMatchedTasksRemovedListener.onFailure(e);
                return;
            }
            removalRefs.decRef();
            collectionComplete.set(true);
            ThreadPool threadPool = this.clusterService.threadPool();
            future.addListener(new ContextPreservingActionListener(threadPool.getThreadContext().newRestorableContext(false), allMatchedTasksRemovedListener), threadPool.executor("management"), null);
            future.addTimeout(Objects.requireNonNullElse(request.getTimeout(), DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT), threadPool, EsExecutors.DIRECT_EXECUTOR_SERVICE);
            nodeTask.addListener(() -> future.onFailure(new TaskCancelledException("task cancelled")));
        } else {
            super.processTasks(nodeTask, request, nodeOperation);
        }
    }

    private static /* synthetic */ void lambda$processTasks$1(AtomicBoolean collectionComplete, RefCounted removalRefs, Set removedTasks, Set matchedTasks, ListenableActionFuture future, List processedTasks, Task task) {
        if (!collectionComplete.get() && removalRefs.tryIncRef()) {
            removedTasks.add(task);
            removalRefs.decRef();
        } else {
            matchedTasks.remove(task);
            if (matchedTasks.isEmpty()) {
                future.onResponse(processedTasks);
            }
        }
    }
}

