/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStats;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.index.stats.IndexingPressureStats;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.monitor.process.ProcessStats;
import org.elasticsearch.node.AdaptiveSelectionStats;
import org.elasticsearch.repositories.RepositoriesStats;
import org.elasticsearch.script.ScriptCacheStats;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.elasticsearch.transport.TransportStats;
import org.elasticsearch.xcontent.ToXContent;

public class NodeStats
extends BaseNodeResponse
implements ChunkedToXContent {
    private final long timestamp;
    @Nullable
    private NodeIndicesStats indices;
    @Nullable
    private final OsStats os;
    @Nullable
    private final ProcessStats process;
    @Nullable
    private final JvmStats jvm;
    @Nullable
    private final ThreadPoolStats threadPool;
    @Nullable
    private final FsInfo fs;
    @Nullable
    private final TransportStats transport;
    @Nullable
    private final HttpStats http;
    @Nullable
    private final AllCircuitBreakerStats breaker;
    @Nullable
    private final ScriptStats scriptStats;
    @Nullable
    private final ScriptCacheStats scriptCacheStats;
    @Nullable
    private final DiscoveryStats discoveryStats;
    @Nullable
    private final IngestStats ingestStats;
    @Nullable
    private final AdaptiveSelectionStats adaptiveSelectionStats;
    @Nullable
    private final IndexingPressureStats indexingPressureStats;
    @Nullable
    private final RepositoriesStats repositoriesStats;
    @Nullable
    private final NodeAllocationStats nodeAllocationStats;

    public NodeStats(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readVLong();
        if (in.readBoolean()) {
            this.indices = new NodeIndicesStats(in);
        }
        this.os = in.readOptionalWriteable(OsStats::new);
        this.process = in.readOptionalWriteable(ProcessStats::new);
        this.jvm = in.readOptionalWriteable(JvmStats::new);
        this.threadPool = in.readOptionalWriteable(ThreadPoolStats::new);
        this.fs = in.readOptionalWriteable(FsInfo::new);
        this.transport = in.readOptionalWriteable(TransportStats::new);
        this.http = in.readOptionalWriteable(HttpStats::new);
        this.breaker = in.readOptionalWriteable(AllCircuitBreakerStats::new);
        this.scriptStats = in.readOptionalWriteable(ScriptStats::read);
        this.scriptCacheStats = this.scriptStats != null ? this.scriptStats.toScriptCacheStats() : null;
        this.discoveryStats = in.readOptionalWriteable(DiscoveryStats::new);
        this.ingestStats = in.readOptionalWriteable(IngestStats::read);
        this.adaptiveSelectionStats = in.readOptionalWriteable(AdaptiveSelectionStats::new);
        this.indexingPressureStats = in.readOptionalWriteable(IndexingPressureStats::new);
        this.repositoriesStats = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readOptionalWriteable(RepositoriesStats::new) : null;
        this.nodeAllocationStats = in.getTransportVersion().onOrAfter(TransportVersions.ALLOCATION_STATS) ? in.readOptionalWriteable(NodeAllocationStats::new) : null;
    }

    public NodeStats(DiscoveryNode node, long timestamp, @Nullable NodeIndicesStats indices, @Nullable OsStats os, @Nullable ProcessStats process, @Nullable JvmStats jvm, @Nullable ThreadPoolStats threadPool, @Nullable FsInfo fs, @Nullable TransportStats transport, @Nullable HttpStats http, @Nullable AllCircuitBreakerStats breaker, @Nullable ScriptStats scriptStats, @Nullable DiscoveryStats discoveryStats, @Nullable IngestStats ingestStats, @Nullable AdaptiveSelectionStats adaptiveSelectionStats, @Nullable ScriptCacheStats scriptCacheStats, @Nullable IndexingPressureStats indexingPressureStats, @Nullable RepositoriesStats repositoriesStats, @Nullable NodeAllocationStats nodeAllocationStats) {
        super(node);
        this.timestamp = timestamp;
        this.indices = indices;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.fs = fs;
        this.transport = transport;
        this.http = http;
        this.breaker = breaker;
        this.scriptStats = scriptStats;
        this.discoveryStats = discoveryStats;
        this.ingestStats = ingestStats;
        this.adaptiveSelectionStats = adaptiveSelectionStats;
        this.scriptCacheStats = scriptCacheStats;
        this.indexingPressureStats = indexingPressureStats;
        this.repositoriesStats = repositoriesStats;
        this.nodeAllocationStats = nodeAllocationStats;
    }

    public NodeStats withNodeAllocationStats(@Nullable NodeAllocationStats nodeAllocationStats, @Nullable DiskThresholdSettings masterThresholdSettings) {
        return new NodeStats(this.getNode(), this.timestamp, this.indices, this.os, this.process, this.jvm, this.threadPool, FsInfo.setEffectiveWatermarks(this.fs, masterThresholdSettings, this.getNode().isDedicatedFrozenNode()), this.transport, this.http, this.breaker, this.scriptStats, this.discoveryStats, this.ingestStats, this.adaptiveSelectionStats, this.scriptCacheStats, this.indexingPressureStats, this.repositoriesStats, nodeAllocationStats);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    @Nullable
    public NodeIndicesStats getIndices() {
        return this.indices;
    }

    @Nullable
    public OsStats getOs() {
        return this.os;
    }

    @Nullable
    public ProcessStats getProcess() {
        return this.process;
    }

    @Nullable
    public JvmStats getJvm() {
        return this.jvm;
    }

    @Nullable
    public ThreadPoolStats getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public FsInfo getFs() {
        return this.fs;
    }

    @Nullable
    public TransportStats getTransport() {
        return this.transport;
    }

    @Nullable
    public HttpStats getHttp() {
        return this.http;
    }

    @Nullable
    public AllCircuitBreakerStats getBreaker() {
        return this.breaker;
    }

    @Nullable
    public ScriptStats getScriptStats() {
        return this.scriptStats;
    }

    @Nullable
    public DiscoveryStats getDiscoveryStats() {
        return this.discoveryStats;
    }

    @Nullable
    public IngestStats getIngestStats() {
        return this.ingestStats;
    }

    @Nullable
    public AdaptiveSelectionStats getAdaptiveSelectionStats() {
        return this.adaptiveSelectionStats;
    }

    @Nullable
    public ScriptCacheStats getScriptCacheStats() {
        return this.scriptCacheStats;
    }

    @Nullable
    public IndexingPressureStats getIndexingPressureStats() {
        return this.indexingPressureStats;
    }

    @Nullable
    public RepositoriesStats getRepositoriesStats() {
        return this.repositoriesStats;
    }

    @Nullable
    public NodeAllocationStats getNodeAllocationStats() {
        return this.nodeAllocationStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        if (this.indices == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indices.writeTo(out);
        }
        out.writeOptionalWriteable(this.os);
        out.writeOptionalWriteable(this.process);
        out.writeOptionalWriteable(this.jvm);
        out.writeOptionalWriteable(this.threadPool);
        out.writeOptionalWriteable(this.fs);
        out.writeOptionalWriteable(this.transport);
        out.writeOptionalWriteable(this.http);
        out.writeOptionalWriteable(this.breaker);
        out.writeOptionalWriteable(this.scriptStats);
        out.writeOptionalWriteable(this.discoveryStats);
        out.writeOptionalWriteable(this.ingestStats);
        out.writeOptionalWriteable(this.adaptiveSelectionStats);
        out.writeOptionalWriteable(this.indexingPressureStats);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeOptionalWriteable(this.repositoriesStats);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.ALLOCATION_STATS)) {
            out.writeOptionalWriteable(this.nodeAllocationStats);
        }
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(ChunkedToXContentHelper.singleChunk((builder, params) -> {
            builder.field("name", this.getNode().getName());
            builder.field("transport_address", this.getNode().getAddress().toString());
            builder.field("host", this.getNode().getHostName());
            builder.field("ip", (ToXContent)this.getNode().getAddress());
            builder.startArray("roles");
            for (DiscoveryNodeRole discoveryNodeRole : this.getNode().getRoles()) {
                builder.value(discoveryNodeRole.roleName());
            }
            builder.endArray();
            if (!this.getNode().getAttributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry entry : this.getNode().getAttributes().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            return builder;
        }), NodeStats.ifPresent(this.getIndices()).toXContentChunked(outerParams), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.value(NodeStats.ifPresent((ToXContent)this.getOs()), p).value(NodeStats.ifPresent((ToXContent)this.getProcess()), p).value(NodeStats.ifPresent((ToXContent)this.getJvm()), p)), NodeStats.ifPresent(this.getThreadPool()).toXContentChunked(outerParams), ChunkedToXContentHelper.singleChunk(NodeStats.ifPresent((ToXContent)this.getFs())), NodeStats.ifPresent(this.getTransport()).toXContentChunked(outerParams), NodeStats.ifPresent(this.getHttp()).toXContentChunked(outerParams), ChunkedToXContentHelper.singleChunk(NodeStats.ifPresent((ToXContent)this.getBreaker())), NodeStats.ifPresent(this.getScriptStats()).toXContentChunked(outerParams), ChunkedToXContentHelper.singleChunk(NodeStats.ifPresent((ToXContent)this.getDiscoveryStats())), NodeStats.ifPresent(this.getIngestStats()).toXContentChunked(outerParams), ChunkedToXContentHelper.singleChunk(NodeStats.ifPresent((ToXContent)this.getAdaptiveSelectionStats())), NodeStats.ifPresent(this.getScriptCacheStats()).toXContentChunked(outerParams), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.value(NodeStats.ifPresent((ToXContent)this.getIndexingPressureStats()), p).value(NodeStats.ifPresent((ToXContent)this.getRepositoriesStats()), p).value(NodeStats.ifPresent((ToXContent)this.getNodeAllocationStats()), p)));
    }

    private static ChunkedToXContent ifPresent(@Nullable ChunkedToXContent chunkedToXContent) {
        return Objects.requireNonNullElse(chunkedToXContent, ChunkedToXContent.EMPTY);
    }

    private static ToXContent ifPresent(@Nullable ToXContent toXContent) {
        return Objects.requireNonNullElse(toXContent, ToXContent.EMPTY);
    }
}

