/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.features;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.features.NodeFeatures;
import org.elasticsearch.action.admin.cluster.node.features.NodesFeaturesRequest;
import org.elasticsearch.action.admin.cluster.node.features.NodesFeaturesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportNodesFeaturesAction
extends TransportNodesAction<NodesFeaturesRequest, NodesFeaturesResponse, NodeFeaturesRequest, NodeFeatures> {
    public static final ActionType<NodesFeaturesResponse> TYPE = new ActionType("cluster:monitor/nodes/features");
    private final FeatureService featureService;

    @Inject
    public TransportNodesFeaturesAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, FeatureService featureService) {
        super(TYPE.name(), clusterService, transportService, actionFilters, NodeFeaturesRequest::new, threadPool.executor("management"));
        this.featureService = featureService;
    }

    @Override
    protected NodesFeaturesResponse newResponse(NodesFeaturesRequest request, List<NodeFeatures> responses, List<FailedNodeException> failures) {
        return new NodesFeaturesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeFeaturesRequest newNodeRequest(NodesFeaturesRequest request) {
        return new NodeFeaturesRequest();
    }

    @Override
    protected NodeFeatures newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeFeatures(in);
    }

    @Override
    protected NodeFeatures nodeOperation(NodeFeaturesRequest request, Task task) {
        return new NodeFeatures(this.featureService.getNodeFeatures().keySet(), this.transportService.getLocalNode());
    }

    public static class NodeFeaturesRequest
    extends TransportRequest {
        public NodeFeaturesRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeFeaturesRequest() {
        }
    }
}

