/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.allocation.AllocationStatsFeatures;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationStatsService;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStats;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAllocationStatsAction
extends TransportMasterNodeReadAction<Request, Response> {
    public static final ActionType<Response> TYPE = new ActionType("cluster:monitor/allocation/stats");
    private final AllocationStatsService allocationStatsService;
    private final DiskThresholdSettings diskThresholdSettings;
    private final FeatureService featureService;

    @Inject
    public TransportGetAllocationStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationStatsService allocationStatsService, FeatureService featureService) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver, Response::new, threadPool.executor("management"));
        this.allocationStatsService = allocationStatsService;
        this.diskThresholdSettings = new DiskThresholdSettings(clusterService.getSettings(), clusterService.getClusterSettings());
        this.featureService = featureService;
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        if (this.clusterService.state().getMinTransportVersion().before(TransportVersions.ALLOCATION_STATS)) {
            listener.onResponse(new Response(Map.of(), null));
            return;
        }
        super.doExecute(task, request, listener);
    }

    @Override
    protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        listener.onResponse(new Response(this.allocationStatsService.stats(), this.featureService.clusterHasFeature(this.clusterService.state(), AllocationStatsFeatures.INCLUDE_DISK_THRESHOLD_SETTINGS) ? this.diskThresholdSettings : null));
    }

    @Override
    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static class Response
    extends ActionResponse {
        private final Map<String, NodeAllocationStats> nodeAllocationStats;
        @Nullable
        private final DiskThresholdSettings diskThresholdSettings;

        public Response(Map<String, NodeAllocationStats> nodeAllocationStats, DiskThresholdSettings diskThresholdSettings) {
            this.nodeAllocationStats = nodeAllocationStats;
            this.diskThresholdSettings = diskThresholdSettings;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.nodeAllocationStats = in.readImmutableMap(StreamInput::readString, NodeAllocationStats::new);
            this.diskThresholdSettings = in.getTransportVersion().onOrAfter(TransportVersions.WATERMARK_THRESHOLDS_STATS) ? in.readOptionalWriteable(DiskThresholdSettings::readFrom) : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.nodeAllocationStats, StreamOutput::writeString, StreamOutput::writeWriteable);
            if (out.getTransportVersion().onOrAfter(TransportVersions.WATERMARK_THRESHOLDS_STATS)) {
                out.writeOptionalWriteable(this.diskThresholdSettings);
            } else assert (this.diskThresholdSettings == null);
        }

        public Map<String, NodeAllocationStats> getNodeAllocationStats() {
            return this.nodeAllocationStats;
        }

        @Nullable
        public DiskThresholdSettings getDiskThresholdSettings() {
            return this.diskThresholdSettings;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public Request(TimeValue masterNodeTimeout, TaskId parentTaskId) {
            super(masterNodeTimeout);
            this.setParentTask(parentTaskId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getTransportVersion().onOrAfter(TransportVersions.ALLOCATION_STATS));
            super.writeTo(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

