/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.packageloader.action;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ModelDownloadTask
extends CancellableTask {
    private final AtomicReference<DownLoadProgress> downloadProgress = new AtomicReference<DownLoadProgress>(new DownLoadProgress(0, 0));

    public ModelDownloadTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    void setProgress(int totalParts, int downloadedParts) {
        this.downloadProgress.set(new DownLoadProgress(totalParts, downloadedParts));
    }

    public DownloadStatus getStatus() {
        return new DownloadStatus(this.downloadProgress.get());
    }

    record DownLoadProgress(int totalParts, int downloadedParts) {
    }

    public record DownloadStatus(DownLoadProgress downloadProgress) implements Task.Status
    {
        public static final String NAME = "model-download";

        public DownloadStatus(StreamInput in) throws IOException {
            this(new DownLoadProgress(in.readVInt(), in.readVInt()));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("total_parts", this.downloadProgress.totalParts);
            builder.field("downloaded_parts", this.downloadProgress.downloadedParts);
            builder.endObject();
            return builder;
        }

        public String getWriteableName() {
            return NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.downloadProgress.totalParts);
            out.writeVInt(this.downloadProgress.downloadedParts);
        }
    }
}

