/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankDoc;

public class RRFRankDoc
extends RankDoc {
    static final String NAME = "rrf_rank_doc";
    public final int[] positions;
    public final float[] scores;

    public RRFRankDoc(int doc, int shardIndex, int queryCount) {
        super(doc, 0.0f, shardIndex);
        this.positions = new int[queryCount];
        Arrays.fill(this.positions, -1);
        this.scores = new float[queryCount];
    }

    public RRFRankDoc(StreamInput in) throws IOException {
        super(in);
        this.rank = in.readVInt();
        this.positions = in.readIntArray();
        this.scores = in.readFloatArray();
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.rank);
        out.writeIntArray(this.positions);
        out.writeFloatArray(this.scores);
    }

    public boolean doEquals(RankDoc rd) {
        RRFRankDoc rrfrd = (RRFRankDoc)rd;
        return Arrays.equals(this.positions, rrfrd.positions) && Arrays.equals(this.scores, rrfrd.scores);
    }

    public int doHashCode() {
        int result = Arrays.hashCode(this.positions);
        result = 31 * result + Arrays.hashCode(this.scores);
        return result;
    }

    public String toString() {
        return "RRFRankDoc{rank=" + this.rank + ", positions=" + Arrays.toString(this.positions) + ", scores=" + Arrays.toString(this.scores) + ", score=" + this.score + ", doc=" + this.doc + ", shardIndex=" + this.shardIndex + "}";
    }

    public String getWriteableName() {
        return NAME;
    }
}

