/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.xpack.rank.rrf.RRFRankDoc;
import org.elasticsearch.xpack.rank.rrf.RRFRankShardResult;

public class RRFQueryPhaseRankCoordinatorContext
extends QueryPhaseRankCoordinatorContext {
    private final int size;
    private final int from;
    private final int rankConstant;

    public RRFQueryPhaseRankCoordinatorContext(int size, int from, int windowSize, int rankConstant) {
        super(windowSize);
        this.size = size;
        this.from = from;
        this.rankConstant = rankConstant;
    }

    public ScoreDoc[] rankQueryPhaseResults(List<QuerySearchResult> querySearchResults, SearchPhaseController.TopDocsStats topDocsStats) {
        int fqi;
        int queryCount = -1;
        ArrayList<1> queues = new ArrayList<1>();
        for (QuerySearchResult querySearchResult : querySearchResults) {
            if (querySearchResult.searchTimedOut()) {
                topDocsStats.timedOut = true;
                continue;
            }
            if (querySearchResult.terminatedEarly() != null && querySearchResult.terminatedEarly().booleanValue()) {
                topDocsStats.terminatedEarly = true;
            }
            assert (querySearchResult.getRankShardResult() instanceof RRFRankShardResult);
            RRFRankShardResult rrfRankShardResult = (RRFRankShardResult)querySearchResult.getRankShardResult();
            if (queryCount == -1) {
                queryCount = rrfRankShardResult.queryCount;
                int qi = 0;
                while (qi < queryCount) {
                    fqi = qi++;
                    queues.add(new PriorityQueue<RRFRankDoc>(this.rankWindowSize){

                        protected boolean lessThan(RRFRankDoc a, RRFRankDoc b) {
                            float score1 = a.scores[fqi];
                            float score2 = b.scores[fqi];
                            if (score1 != score2) {
                                return score1 < score2;
                            }
                            if (a.shardIndex != b.shardIndex) {
                                return a.shardIndex > b.shardIndex;
                            }
                            return a.doc > b.doc;
                        }
                    });
                }
            }
            assert (queryCount == rrfRankShardResult.queryCount);
            for (RRFRankDoc rrfRankDoc : rrfRankShardResult.rrfRankDocs) {
                assert (rrfRankDoc.shardIndex == -1);
                rrfRankDoc.shardIndex = querySearchResult.getShardIndex();
                for (int qi = 0; qi < queryCount; ++qi) {
                    if (rrfRankDoc.positions[qi] == -1) continue;
                    ((PriorityQueue)queues.get(qi)).insertWithOverflow((Object)rrfRankDoc);
                }
            }
        }
        if (queues.isEmpty()) {
            return new ScoreDoc[0];
        }
        Map results = Maps.newMapWithExpectedSize((int)(queryCount * this.rankWindowSize));
        int fqc = queryCount;
        for (int qi = 0; qi < queryCount; ++qi) {
            PriorityQueue queue = (PriorityQueue)queues.get(qi);
            fqi = qi;
            int rank = queue.size();
            while (rank > 0) {
                RRFRankDoc rrfRankDoc;
                rrfRankDoc = (RRFRankDoc)((Object)queue.pop());
                int frank = rank--;
                results.compute(new RankDoc.RankKey(rrfRankDoc.doc, rrfRankDoc.shardIndex), (key, value) -> {
                    if (value == null) {
                        value = new RRFRankDoc(rrfRankDoc.doc, rrfRankDoc.shardIndex, fqc);
                    }
                    value.score += 1.0f / (float)(this.rankConstant + frank);
                    value.positions[fqi] = frank - 1;
                    value.scores[fqi] = rrfRankDoc.scores[fqi];
                    return value;
                });
            }
        }
        if (results.values().size() - this.from <= 0) {
            return new ScoreDoc[0];
        }
        RRFRankDoc[] sortedResults = (RRFRankDoc[])results.values().toArray(RRFRankDoc[]::new);
        Arrays.sort(sortedResults, (rrf1, rrf2) -> {
            if (rrf1.score != rrf2.score) {
                return rrf1.score < rrf2.score ? 1 : -1;
            }
            assert (rrf1.positions.length == rrf2.positions.length);
            for (int qi = 0; qi < rrf1.positions.length; ++qi) {
                if (rrf1.positions[qi] != -1 && rrf2.positions[qi] != -1) {
                    if (rrf1.scores[qi] == rrf2.scores[qi]) continue;
                    return rrf1.scores[qi] < rrf2.scores[qi] ? 1 : -1;
                }
                if (rrf1.positions[qi] != -1) {
                    return -1;
                }
                if (rrf2.positions[qi] == -1) continue;
                return 1;
            }
            if (rrf1.shardIndex != rrf2.shardIndex) {
                return rrf1.shardIndex < rrf2.shardIndex ? -1 : 1;
            }
            return rrf1.doc < rrf2.doc ? -1 : 1;
        });
        RRFRankDoc[] topResults = new RRFRankDoc[Math.min(this.size, sortedResults.length - this.from)];
        for (int rank = 0; rank < topResults.length; ++rank) {
            topResults[rank] = sortedResults[this.from + rank];
            topResults[rank].rank = rank + 1 + this.from;
        }
        assert (topDocsStats.fetchHits == 0L);
        topDocsStats.fetchHits = topResults.length;
        return topResults;
    }
}

