/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateFormatter;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.ToCharFormatter;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class DateTimeFormatProcessor
extends BinaryDateTimeProcessor {
    public static final String NAME = "dtformat";
    private static final Set<Character> MS_DATETIME_PATTERN_CHARS = Set.of(Character.valueOf('d'), Character.valueOf('f'), Character.valueOf('F'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('H'), Character.valueOf('K'), Character.valueOf('m'), Character.valueOf('M'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf(':'), Character.valueOf('/'), Character.valueOf(' '), Character.valueOf('-'));
    private static final Set<Character> MS_QUOTING_CHARS = Set.of(Character.valueOf('\\'), Character.valueOf('\''), Character.valueOf('\"'));
    private static final String[][] MS_TO_JAVA_PATTERNS = new String[][]{{"tt", "a"}, {"t", "a"}, {"dddd", "eeee"}, {"ddd", "eee"}, {"K", "v"}, {"g", "G"}, {"f", "S"}, {"F", "S"}, {"z", "X"}};
    private final Formatter formatter;

    public DateTimeFormatProcessor(Processor source1, Processor source2, ZoneId zoneId, Formatter formatter) {
        super(source1, source2, zoneId);
        this.formatter = formatter;
    }

    public DateTimeFormatProcessor(StreamInput in) throws IOException {
        super(in);
        this.formatter = (Formatter)in.readEnum(Formatter.class);
    }

    @Override
    protected void doWrite(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.formatter);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object timestamp, Object pattern) {
        return this.formatter.format(timestamp, pattern, this.zoneId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.formatter});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DateTimeFormatProcessor other = (DateTimeFormatProcessor)((Object)obj);
        return super.equals((Object)other) && Objects.equals((Object)this.formatter, (Object)other.formatter);
    }

    public Formatter formatter() {
        return this.formatter;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Formatter {
        FORMAT{

            @Override
            protected Function<TemporalAccessor, String> formatterFor(String pattern) {
                if (pattern.isEmpty()) {
                    return null;
                }
                String javaPattern = 1.msToJavaPattern(pattern);
                return DateTimeFormatter.ofPattern(javaPattern, Locale.ROOT)::format;
            }
        }
        ,
        DATE_FORMAT{

            @Override
            protected Function<TemporalAccessor, String> formatterFor(String pattern) {
                return DateFormatter.ofPattern(pattern);
            }
        }
        ,
        DATE_TIME_FORMAT{

            @Override
            protected Function<TemporalAccessor, String> formatterFor(String pattern) {
                return DateTimeFormatter.ofPattern(pattern, Locale.ROOT)::format;
            }
        }
        ,
        TO_CHAR{

            @Override
            protected Function<TemporalAccessor, String> formatterFor(String pattern) {
                return ToCharFormatter.ofPattern(pattern);
            }
        };


        protected static String msToJavaPattern(String pattern) {
            StringBuilder result = new StringBuilder(pattern.length());
            StringBuilder partialQuotedString = new StringBuilder();
            boolean originalCharacterQuoted = false;
            boolean lastTargetCharacterQuoted = false;
            char quotingChar = '\\';
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (originalCharacterQuoted) {
                    if (quotingChar == '\\') {
                        originalCharacterQuoted = false;
                        lastTargetCharacterQuoted = true;
                        partialQuotedString.append(c);
                        continue;
                    }
                    if (c == quotingChar) {
                        originalCharacterQuoted = false;
                        continue;
                    }
                    partialQuotedString.append(c);
                    continue;
                }
                boolean characterProcessed = false;
                if (MS_QUOTING_CHARS.contains(Character.valueOf(c))) {
                    originalCharacterQuoted = true;
                    lastTargetCharacterQuoted = true;
                    quotingChar = c;
                    characterProcessed = true;
                } else {
                    for (String[] item : MS_TO_JAVA_PATTERNS) {
                        int fragmentLength = item[0].length();
                        if (i + fragmentLength > pattern.length() || !item[0].equals(pattern.substring(i, i + fragmentLength))) continue;
                        if (lastTargetCharacterQuoted) {
                            lastTargetCharacterQuoted = false;
                            Formatter.quoteAndAppend(result, partialQuotedString);
                            partialQuotedString = new StringBuilder();
                        }
                        result.append(item[1]);
                        characterProcessed = true;
                        i += fragmentLength - 1;
                        break;
                    }
                }
                if (characterProcessed) continue;
                if (!MS_DATETIME_PATTERN_CHARS.contains(Character.valueOf(c))) {
                    lastTargetCharacterQuoted = true;
                    partialQuotedString.append(c);
                    continue;
                }
                if (lastTargetCharacterQuoted) {
                    lastTargetCharacterQuoted = false;
                    Formatter.quoteAndAppend(result, partialQuotedString);
                    partialQuotedString = new StringBuilder();
                }
                result.append(c);
            }
            if (lastTargetCharacterQuoted) {
                Formatter.quoteAndAppend(result, partialQuotedString);
            }
            return result.toString();
        }

        private static void quoteAndAppend(StringBuilder mainBuffer, StringBuilder fragmentToQuote) {
            mainBuffer.append("'");
            mainBuffer.append(fragmentToQuote.toString().replace("'", "''"));
            mainBuffer.append("'");
        }

        protected abstract Function<TemporalAccessor, String> formatterFor(String var1);

        public Object format(Object timestamp, Object pattern, ZoneId zoneId) {
            if (timestamp == null || pattern == null) {
                return null;
            }
            if (!(pattern instanceof String)) {
                throw new SqlIllegalArgumentException("A string is required; received [{}]", pattern);
            }
            String patternString = (String)pattern;
            if (patternString.isEmpty()) {
                return null;
            }
            if (!(timestamp instanceof ZonedDateTime) && !(timestamp instanceof OffsetTime)) {
                throw new SqlIllegalArgumentException("A date/datetime/time is required; received [{}]", timestamp);
            }
            Comparable<ChronoZonedDateTime<?>> ta = timestamp instanceof ZonedDateTime ? ((ZonedDateTime)timestamp).withZoneSameInstant(zoneId) : DateUtils.asTimeAtZone((OffsetTime)timestamp, zoneId);
            try {
                return this.formatterFor(patternString).apply((TemporalAccessor)((Object)ta));
            }
            catch (IllegalArgumentException | DateTimeException e) {
                throw new InvalidArgumentException("Invalid pattern [{}] is received for formatting date/time [{}]; {}", new Object[]{pattern, timestamp, e.getMessage()});
            }
        }
    }
}

