/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.downsample.DownsampleIndexerAction;
import org.elasticsearch.xpack.core.downsample.DownsampleShardIndexerStatus;
import org.elasticsearch.xpack.core.downsample.DownsampleShardPersistentTaskState;
import org.elasticsearch.xpack.core.downsample.DownsampleShardTask;
import org.elasticsearch.xpack.downsample.DownsampleMetrics;
import org.elasticsearch.xpack.downsample.DownsampleShardIndexer;

public class TransportDownsampleIndexerAction
extends TransportBroadcastAction<DownsampleIndexerAction.Request, DownsampleIndexerAction.Response, DownsampleIndexerAction.ShardDownsampleRequest, DownsampleIndexerAction.ShardDownsampleResponse> {
    private final Client client;
    private final IndicesService indicesService;
    private final DownsampleMetrics downsampleMetrics;

    @Inject
    public TransportDownsampleIndexerAction(Client client, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DownsampleMetrics downsampleMetrics) {
        super("indices:admin/xpack/downsample_indexer", clusterService, transportService, actionFilters, indexNameExpressionResolver, DownsampleIndexerAction.Request::new, DownsampleIndexerAction.ShardDownsampleRequest::new, (Executor)transportService.getThreadPool().executor("downsample_indexing"));
        this.client = new OriginSettingClient(client, "rollup");
        this.indicesService = indicesService;
        this.downsampleMetrics = downsampleMetrics;
    }

    protected GroupShardsIterator<ShardIterator> shards(ClusterState clusterState, DownsampleIndexerAction.Request request, String[] concreteIndices) {
        if (concreteIndices.length > 1) {
            throw new IllegalArgumentException("multiple indices: " + Arrays.toString(concreteIndices));
        }
        GroupShardsIterator groups = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, null, null);
        for (ShardIterator group : groups) {
            if (group.size() != 0) continue;
            throw new NoShardAvailableActionException(group.shardId());
        }
        return groups;
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, DownsampleIndexerAction.Request request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, DownsampleIndexerAction.Request request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    protected void doExecute(Task task, DownsampleIndexerAction.Request request, ActionListener<DownsampleIndexerAction.Response> listener) {
        new Async(task, request, listener).start();
    }

    protected DownsampleIndexerAction.ShardDownsampleRequest newShardRequest(int numShards, ShardRouting shard, DownsampleIndexerAction.Request request) {
        return new DownsampleIndexerAction.ShardDownsampleRequest(shard.shardId(), request);
    }

    protected DownsampleIndexerAction.ShardDownsampleResponse shardOperation(DownsampleIndexerAction.ShardDownsampleRequest request, Task task) throws IOException {
        IndexService indexService = this.indicesService.indexService(request.shardId().getIndex());
        DownsampleShardIndexer indexer = new DownsampleShardIndexer((DownsampleShardTask)task, this.client, indexService, this.downsampleMetrics, request.shardId(), request.getDownsampleIndex(), request.getRollupConfig(), request.getMetricFields(), request.getLabelFields(), request.getDimensionFields(), new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.INITIALIZED, null));
        return indexer.execute();
    }

    protected DownsampleIndexerAction.ShardDownsampleResponse readShardResponse(StreamInput in) throws IOException {
        return new DownsampleIndexerAction.ShardDownsampleResponse(in);
    }

    protected DownsampleIndexerAction.Response newResponse(DownsampleIndexerAction.Request request, AtomicReferenceArray<?> shardsResponses, ClusterState clusterState) {
        long numIndexed = 0L;
        int successfulShards = 0;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) {
                throw new ElasticsearchException("missing shard", new Object[0]);
            }
            if (shardResponse instanceof DownsampleIndexerAction.ShardDownsampleResponse) {
                DownsampleIndexerAction.ShardDownsampleResponse r = (DownsampleIndexerAction.ShardDownsampleResponse)shardResponse;
                ++successfulShards;
                numIndexed += r.getNumIndexed();
                continue;
            }
            if (shardResponse instanceof Exception) {
                Exception e = (Exception)shardResponse;
                throw new ElasticsearchException((Throwable)e);
            }
            assert (false) : "unknown response [" + shardResponse + "]";
            throw new IllegalStateException("unknown response [" + shardResponse + "]");
        }
        return new DownsampleIndexerAction.Response(true, shardsResponses.length(), successfulShards, 0, numIndexed);
    }

    private class Async
    extends TransportBroadcastAction.AsyncBroadcastAction {
        private final DownsampleIndexerAction.Request request;
        private final ActionListener<DownsampleIndexerAction.Response> listener;

        protected Async(Task task, DownsampleIndexerAction.Request request, ActionListener<DownsampleIndexerAction.Response> listener) {
            super((TransportBroadcastAction)TransportDownsampleIndexerAction.this, task, (BroadcastRequest)request, listener);
            this.request = request;
            this.listener = listener;
        }

        protected void finishHim() {
            try {
                DownsampleIndexerAction.Response resp = TransportDownsampleIndexerAction.this.newResponse(this.request, this.shardsResponses, TransportDownsampleIndexerAction.this.clusterService.state());
                this.listener.onResponse((Object)resp);
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }
    }
}

