/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateDoubleMetricFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.AggregateMetricFieldValueFetcher;
import org.elasticsearch.xpack.downsample.LabelFieldProducer;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

class FieldValueFetcher {
    protected final String name;
    protected final MappedFieldType fieldType;
    protected final IndexFieldData<?> fieldData;
    protected final AbstractDownsampleFieldProducer fieldProducer;

    protected FieldValueFetcher(String name, MappedFieldType fieldType, IndexFieldData<?> fieldData) {
        this.name = name;
        this.fieldType = fieldType;
        this.fieldData = fieldData;
        this.fieldProducer = this.createFieldProducer();
    }

    public String name() {
        return this.name;
    }

    public FormattedDocValues getLeaf(LeafReaderContext context) {
        DocValueFormat format = this.fieldType.docValueFormat(null, null);
        return this.fieldData.load(context).getFormattedValues(format);
    }

    public AbstractDownsampleFieldProducer fieldProducer() {
        return this.fieldProducer;
    }

    private AbstractDownsampleFieldProducer createFieldProducer() {
        if (this.fieldType.getMetricType() != null) {
            return switch (this.fieldType.getMetricType()) {
                default -> throw new IncompatibleClassChangeError();
                case TimeSeriesParams.MetricType.GAUGE -> new MetricFieldProducer.GaugeMetricFieldProducer(this.name());
                case TimeSeriesParams.MetricType.COUNTER -> new MetricFieldProducer.CounterMetricFieldProducer(this.name());
                case TimeSeriesParams.MetricType.POSITION -> throw new IllegalArgumentException("Unsupported metric type [position] for down-sampling");
            };
        }
        if ("histogram".equals(this.fieldType.typeName())) {
            return new LabelFieldProducer.HistogramLastLabelFieldProducer(this.name());
        }
        return new LabelFieldProducer.LabelLastValueFieldProducer(this.name());
    }

    static List<FieldValueFetcher> create(SearchExecutionContext context, String[] fields) {
        ArrayList<FieldValueFetcher> fetchers = new ArrayList<FieldValueFetcher>();
        for (String field : fields) {
            MappedFieldType fieldType = context.getFieldType(field);
            assert (fieldType != null) : "Unknown field type for field: [" + field + "]";
            if (fieldType instanceof AggregateDoubleMetricFieldMapper.AggregateDoubleMetricFieldType) {
                AggregateDoubleMetricFieldMapper.AggregateDoubleMetricFieldType aggMetricFieldType = (AggregateDoubleMetricFieldMapper.AggregateDoubleMetricFieldType)fieldType;
                for (NumberFieldMapper.NumberFieldType metricSubField : aggMetricFieldType.getMetricFields().values()) {
                    if (!context.fieldExistsInIndex(metricSubField.name())) continue;
                    IndexFieldData fieldData = context.getForField((MappedFieldType)metricSubField, MappedFieldType.FielddataOperation.SEARCH);
                    fetchers.add(new AggregateMetricFieldValueFetcher((MappedFieldType)metricSubField, aggMetricFieldType, fieldData));
                }
                continue;
            }
            if (!context.fieldExistsInIndex(field)) continue;
            IndexFieldData fieldData = context.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH);
            String fieldName = context.isMultiField(field) ? fieldType.name().substring(0, fieldType.name().lastIndexOf(46)) : fieldType.name();
            fetchers.add(new FieldValueFetcher(fieldName, fieldType, fieldData));
        }
        return Collections.unmodifiableList(fetchers);
    }
}

