/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestUpdateDatafeedAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/datafeeds/{" + DatafeedConfig.ID + "}/_update")).replaces(RestRequest.Method.POST, "/_xpack/ml/datafeeds/{" + DatafeedConfig.ID + "}/_update", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_update_datafeed_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        UpdateDatafeedAction.Request updateDatafeedRequest;
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        IndicesOptions indicesOptions = null;
        if (restRequest.hasParam("expand_wildcards") || restRequest.hasParam("ignore_unavailable") || restRequest.hasParam("allow_no_indices") || restRequest.hasParam("ignore_throttled")) {
            indicesOptions = IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)SearchRequest.DEFAULT_INDICES_OPTIONS);
        }
        try (XContentParser parser = restRequest.contentParser();){
            updateDatafeedRequest = UpdateDatafeedAction.Request.parseRequest((String)datafeedId, (IndicesOptions)indicesOptions, (XContentParser)parser);
        }
        updateDatafeedRequest.ackTimeout(RestUtils.getAckTimeout((RestRequest)restRequest));
        updateDatafeedRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout((RestRequest)restRequest));
        return channel -> client.execute((ActionType)UpdateDatafeedAction.INSTANCE, (ActionRequest)updateDatafeedRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

