/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.util.Arrays;
import org.elasticsearch.xpack.ml.aggs.MlAggsHelper;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangeType;
import org.elasticsearch.xpack.ml.aggs.changepoint.KDE;

final class SpikeAndDipDetector {
    private final int numValues;
    private final int dipIndex;
    private final int spikeIndex;
    private final double dipValue;
    private final double spikeValue;
    private final KDE spikeTestKDE;
    private final KDE dipTestKDE;

    private int argmax(double[] values, int start, int end, boolean negate) {
        int argmax = 0;
        double max = negate ? -values[0] : values[0];
        for (int i = 1; i < values.length; ++i) {
            double value;
            double d = value = negate ? -values[i] : values[i];
            if (!(value > max)) continue;
            argmax = i;
            max = value;
        }
        return argmax;
    }

    private double sum(double[] values, int start, int end, boolean negate) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            sum += values[i];
        }
        return negate ? -sum : sum;
    }

    private SpikeOrDip findSpikeOrDip(double[] values, int extent, boolean negate) {
        extent = Math.min(extent, values.length - 1);
        int argmax = this.argmax(values, 0, values.length, negate);
        int maxStart = Math.max(0, argmax + 1 - extent);
        int maxEnd = Math.min(maxStart + extent, values.length);
        double maxSum = this.sum(values, maxStart, maxEnd, negate);
        for (int start = maxStart + 1; start <= argmax && start + extent < values.length; ++start) {
            double average = this.sum(values, start, start + extent, negate);
            if (!(average > maxSum)) continue;
            maxStart = start;
            maxSum = average;
        }
        return new SpikeOrDip(argmax, maxStart, maxStart + extent);
    }

    private double[] removeIf(ExcludedPredicate should, double[] values) {
        int numKept = 0;
        for (int i = 0; i < values.length; ++i) {
            if (should.exclude(i)) continue;
            ++numKept;
        }
        double[] newValues = new double[numKept];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (should.exclude(i)) continue;
            newValues[j++] = values[i];
        }
        return newValues;
    }

    SpikeAndDipDetector(double[] values) {
        this.numValues = values.length;
        if (values.length < 4) {
            this.dipIndex = -1;
            this.spikeIndex = -1;
            this.dipValue = Double.NaN;
            this.spikeValue = Double.NaN;
            this.spikeTestKDE = null;
            this.dipTestKDE = null;
            return;
        }
        int spikeLength = Math.max((int)(0.1 * (double)values.length + 0.5), 2) - 1;
        SpikeOrDip dip = this.findSpikeOrDip(values, spikeLength, true);
        SpikeOrDip spike = this.findSpikeOrDip(values, spikeLength, false);
        this.dipIndex = dip.index();
        this.spikeIndex = spike.index();
        this.dipValue = dip.value(values);
        this.spikeValue = spike.value(values);
        double[] dipKDEValues = this.removeIf(i -> dip.includes(i) || i == spike.index(), values);
        double[] spikeKDEValues = this.removeIf(i -> spike.includes(i) || i == dip.index(), values);
        Arrays.sort(dipKDEValues);
        Arrays.sort(spikeKDEValues);
        this.dipTestKDE = new KDE(dipKDEValues, 1.36);
        this.spikeTestKDE = new KDE(spikeKDEValues, 1.36);
    }

    ChangeType at(double pValueThreshold, MlAggsHelper.DoubleBucketValues bucketValues) {
        if (this.dipIndex == -1 || this.spikeIndex == -1) {
            return new ChangeType.Indeterminable("not enough buckets to check for dip or spike. Requires at least [3]; found [" + this.numValues + "]");
        }
        KDE.ValueAndMagnitude dipLeftTailTest = this.dipTestKDE.cdf(this.dipValue);
        KDE.ValueAndMagnitude spikeRightTailTest = this.spikeTestKDE.sf(this.spikeValue);
        double dipPValue = dipLeftTailTest.pValue(this.numValues);
        double spikePValue = spikeRightTailTest.pValue(this.numValues);
        if (dipPValue < pValueThreshold && spikePValue < pValueThreshold) {
            if (dipLeftTailTest.isMoreSignificant(spikeRightTailTest)) {
                return new ChangeType.Dip(dipPValue, bucketValues.getBucketIndex(this.dipIndex));
            }
            return new ChangeType.Spike(spikePValue, bucketValues.getBucketIndex(this.spikeIndex));
        }
        if (dipPValue < pValueThreshold) {
            return new ChangeType.Dip(dipPValue, bucketValues.getBucketIndex(this.dipIndex));
        }
        if (spikePValue < pValueThreshold) {
            return new ChangeType.Spike(spikePValue, bucketValues.getBucketIndex(this.spikeIndex));
        }
        return new ChangeType.Stationary();
    }

    double dipValue() {
        return this.dipValue;
    }

    double spikeValue() {
        return this.spikeValue;
    }

    KDE spikeTestKDE() {
        return this.spikeTestKDE;
    }

    KDE dipTestKDE() {
        return this.dipTestKDE;
    }

    private record SpikeOrDip(int index, int startExcluded, int endExcluded) {
        double value(double[] values) {
            return values[this.index];
        }

        boolean includes(int i) {
            return i >= this.startExcluded && i < this.endExcluded;
        }
    }

    private static interface ExcludedPredicate {
        public boolean exclude(int var1);
    }
}

