/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.get.TransportGetTaskAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.core.ml.annotations.AnnotationIndex;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportRevertModelSnapshotAction
extends TransportMasterNodeAction<RevertModelSnapshotAction.Request, RevertModelSnapshotAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportRevertModelSnapshotAction.class);
    private final Client client;
    private final JobManager jobManager;
    private final JobResultsProvider jobResultsProvider;
    private final JobDataCountsPersister jobDataCountsPersister;

    @Inject
    public TransportRevertModelSnapshotAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager, JobResultsProvider jobResultsProvider, ClusterService clusterService, Client client, JobDataCountsPersister jobDataCountsPersister) {
        super("cluster:admin/xpack/ml/job/model_snapshots/revert", transportService, clusterService, threadPool, actionFilters, RevertModelSnapshotAction.Request::new, indexNameExpressionResolver, RevertModelSnapshotAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.jobManager = jobManager;
        this.jobResultsProvider = jobResultsProvider;
        this.jobDataCountsPersister = jobDataCountsPersister;
    }

    protected void masterOperation(Task task, RevertModelSnapshotAction.Request request, ClusterState state, ActionListener<RevertModelSnapshotAction.Response> listener) {
        String jobId = request.getJobId();
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        logger.debug("Received request to revert to snapshot id '{}' for job '{}', deleting intervening results: {}", (Object)request.getSnapshotId(), (Object)jobId, (Object)request.getDeleteInterveningResults());
        ActionListener annotationsIndexUpdateListener = ActionListener.wrap(r -> {
            ActionListener jobListener = ActionListener.wrap(job -> {
                PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
                JobState jobState = MlTasks.getJobState((String)job.getId(), (PersistentTasksCustomMetadata)tasks);
                if (!request.isForce() && !jobState.equals((Object)JobState.CLOSED)) {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Can only revert to a model snapshot when the job is closed."), (Object[])new Object[0])));
                    return;
                }
                if (MlTasks.getSnapshotUpgraderTask((String)jobId, (String)request.getSnapshotId(), (PersistentTasksCustomMetadata)tasks) != null) {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"Cannot revert job [{}] to snapshot [{}] as it is being upgraded", (Object[])new Object[]{jobId, request.getSnapshotId()})));
                    return;
                }
                this.isBlocked((Job)job, request, (ActionListener<Boolean>)ActionListener.wrap(isBlocked -> {
                    if (isBlocked.booleanValue()) {
                        listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"cannot revert job [{}] to snapshot [{}] while it is blocked with [{}]", (Object[])new Object[]{jobId, request.getSnapshotId(), job.getBlocked().getReason()})));
                    } else {
                        this.jobManager.updateJobBlockReason(jobId, new Blocked(Blocked.Reason.REVERT, taskId), (ActionListener<PutJobAction.Response>)ActionListener.wrap(aBoolean -> this.revertSnapshot(jobId, request, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            this.jobManager.getJob(jobId, (ActionListener<Job>)jobListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener configMappingUpdateListener = ActionListener.wrap(r -> AnnotationIndex.createAnnotationsIndexIfNecessaryAndWaitForYellow((Client)this.client, (ClusterState)state, (TimeValue)request.masterNodeTimeout(), (ActionListener)annotationsIndexUpdateListener), arg_0 -> listener.onFailure(arg_0));
        ActionListener jobExistsListener = ActionListener.wrap(r -> ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)state, (TimeValue)request.masterNodeTimeout(), (ActionListener)configMappingUpdateListener, (int)1), arg_0 -> listener.onFailure(arg_0));
        ActionListener createStateIndexListener = ActionListener.wrap(r -> this.jobManager.jobExists(jobId, null, (ActionListener<Boolean>)jobExistsListener), arg_0 -> listener.onFailure(arg_0));
        AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessary((Client)this.client, (ClusterState)state, (IndexNameExpressionResolver)this.indexNameExpressionResolver, (TimeValue)request.masterNodeTimeout(), (ActionListener)createStateIndexListener);
    }

    private void isBlocked(Job job, RevertModelSnapshotAction.Request request, ActionListener<Boolean> listener) {
        if (job.getBlocked().getReason() == Blocked.Reason.NONE) {
            listener.onResponse((Object)false);
            return;
        }
        if (job.getBlocked().getReason() == Blocked.Reason.REVERT) {
            GetTaskRequest getTaskRequest = new GetTaskRequest();
            getTaskRequest.setTaskId(job.getBlocked().getTaskId());
            getTaskRequest.setWaitForCompletion(request.isForce());
            getTaskRequest.setTimeout(request.ackTimeout());
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportGetTaskAction.TYPE, (ActionRequest)getTaskRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)(!r.getTask().isCompleted() ? 1 : 0)), e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onResponse((Object)false);
                } else {
                    listener.onFailure(e);
                }
            }));
        } else {
            listener.onResponse((Object)true);
        }
    }

    private void revertSnapshot(String jobId, RevertModelSnapshotAction.Request request, ActionListener<RevertModelSnapshotAction.Response> listener) {
        ActionListener finalListener = ActionListener.wrap(r -> this.jobManager.updateJobBlockReason(jobId, Blocked.none(), (ActionListener<PutJobAction.Response>)ActionListener.wrap(aBoolean -> listener.onResponse(r), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), e -> this.jobManager.updateJobBlockReason(jobId, Blocked.none(), (ActionListener<PutJobAction.Response>)ActionListener.wrap(aBoolean -> listener.onFailure(e), arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        TransportRevertModelSnapshotAction.getModelSnapshot(request, this.jobResultsProvider, modelSnapshot -> {
            ActionListener<RevertModelSnapshotAction.Response> wrappedListener = finalListener;
            if (request.getDeleteInterveningResults()) {
                wrappedListener = this.wrapDeleteOldAnnotationsListener(wrappedListener, (ModelSnapshot)modelSnapshot, jobId);
                wrappedListener = this.wrapDeleteOldDataListener(wrappedListener, (ModelSnapshot)modelSnapshot, jobId);
                wrappedListener = this.wrapRevertDataCountsListener(wrappedListener, (ModelSnapshot)modelSnapshot, jobId);
            }
            this.jobManager.revertSnapshot(request, wrappedListener, (ModelSnapshot)modelSnapshot);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private static void getModelSnapshot(RevertModelSnapshotAction.Request request, JobResultsProvider provider, Consumer<ModelSnapshot> handler, Consumer<Exception> errorHandler) {
        logger.info("Reverting to snapshot '" + request.getSnapshotId() + "'");
        if (ModelSnapshot.isTheEmptySnapshot((String)request.getSnapshotId())) {
            handler.accept(ModelSnapshot.emptySnapshot((String)request.getJobId()));
            return;
        }
        provider.getModelSnapshot(request.getJobId(), request.getSnapshotId(), true, modelSnapshot -> {
            if (modelSnapshot == null) {
                throw TransportRevertModelSnapshotAction.missingSnapshotException(request);
            }
            handler.accept((ModelSnapshot)modelSnapshot.result);
        }, errorHandler);
    }

    private static ResourceNotFoundException missingSnapshotException(RevertModelSnapshotAction.Request request) {
        return new ResourceNotFoundException(Messages.getMessage((String)"No model snapshot with id [{0}] exists for job [{1}]", (Object[])new Object[]{request.getSnapshotId(), request.getJobId()}), new Object[0]);
    }

    private ActionListener<RevertModelSnapshotAction.Response> wrapDeleteOldAnnotationsListener(ActionListener<RevertModelSnapshotAction.Response> listener, ModelSnapshot modelSnapshot, String jobId) {
        return ActionListener.wrap(response -> {
            Date deleteAfter = modelSnapshot.getLatestResultTimeStamp() == null ? new Date(0L) : modelSnapshot.getLatestResultTimeStamp();
            logger.info("[{}] Removing intervening annotations after reverting model: deleting annotations after [{}]", (Object)jobId, (Object)deleteAfter);
            JobDataDeleter dataDeleter = new JobDataDeleter(this.client, jobId);
            Set<String> eventsToDelete = Set.of(Annotation.Event.DELAYED_DATA.toString(), Annotation.Event.MODEL_CHANGE.toString());
            dataDeleter.deleteAnnotations(deleteAfter.getTime() + 1L, null, eventsToDelete, (ActionListener<Boolean>)listener.safeMap(r -> response));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private ActionListener<RevertModelSnapshotAction.Response> wrapDeleteOldDataListener(ActionListener<RevertModelSnapshotAction.Response> listener, ModelSnapshot modelSnapshot, String jobId) {
        return ActionListener.wrap(response -> {
            Date deleteAfter = modelSnapshot.getLatestResultTimeStamp() == null ? new Date(0L) : modelSnapshot.getLatestResultTimeStamp();
            logger.info("[{}] Removing intervening records after reverting model: deleting results after [{}]", (Object)jobId, (Object)deleteAfter);
            JobDataDeleter dataDeleter = new JobDataDeleter(this.client, jobId);
            dataDeleter.deleteResultsFromTime(deleteAfter.getTime() + 1L, (ActionListener<Boolean>)listener.safeMap(r -> response));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private ActionListener<RevertModelSnapshotAction.Response> wrapRevertDataCountsListener(ActionListener<RevertModelSnapshotAction.Response> listener, ModelSnapshot modelSnapshot, String jobId) {
        return ActionListener.wrap(response -> this.jobResultsProvider.dataCounts(jobId, counts -> {
            counts.setLatestRecordTimeStamp(modelSnapshot.getLatestRecordTimeStamp());
            this.jobDataCountsPersister.persistDataCountsAsync(jobId, (DataCounts)counts, (ActionListener<Boolean>)listener.safeMap(r -> response));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), arg_0 -> listener.onFailure(arg_0));
    }

    protected ClusterBlockException checkBlock(RevertModelSnapshotAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

