/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.ml.action.GetDeploymentStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsStatsAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelType;
import org.elasticsearch.xpack.core.ml.inference.assignment.AssignmentStats;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceStats;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModelSizeStats;
import org.elasticsearch.xpack.core.ml.utils.InferenceProcessorInfoExtractor;
import org.elasticsearch.xpack.core.ml.utils.TransportVersionUtils;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelDefinitionDoc;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;

public class TransportGetTrainedModelsStatsAction
extends TransportAction<GetTrainedModelsStatsAction.Request, GetTrainedModelsStatsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetTrainedModelsStatsAction.class);
    private final Client client;
    private final ClusterService clusterService;
    private final TrainedModelProvider trainedModelProvider;
    private final Executor executor;

    @Inject
    public TransportGetTrainedModelsStatsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, TrainedModelProvider trainedModelProvider, Client client) {
        super("cluster:monitor/xpack/ml/inference/stats/get", actionFilters, transportService.getTaskManager());
        this.client = client;
        this.clusterService = clusterService;
        this.trainedModelProvider = trainedModelProvider;
        this.executor = threadPool.executor("ml_utility");
    }

    protected void doExecute(Task task, GetTrainedModelsStatsAction.Request request, ActionListener<GetTrainedModelsStatsAction.Response> listener) {
        this.executor.execute((Runnable)ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, (ActionListener<GetTrainedModelsStatsAction.Response>)l)));
    }

    protected void doExecuteForked(Task task, GetTrainedModelsStatsAction.Request request, ActionListener<GetTrainedModelsStatsAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ModelAliasMetadata modelAliasMetadata = ModelAliasMetadata.fromState((ClusterState)this.clusterService.state());
        TrainedModelAssignmentMetadata assignmentMetadata = TrainedModelAssignmentMetadata.fromState((ClusterState)this.clusterService.state());
        Set<String> matchedDeploymentIds = TransportGetTrainedModelsStatsAction.matchedDeploymentIds(request.getResourceId(), assignmentMetadata);
        GetTrainedModelsStatsAction.Response.Builder responseBuilder = new GetTrainedModelsStatsAction.Response.Builder();
        SubscribableListener.newForked(l -> {
            String idExpression = TransportGetTrainedModelsStatsAction.addModelsUsedInMatchingDeployments(request.getResourceId(), assignmentMetadata);
            logger.debug("Expanded models/deployment Ids request [{}]", (Object)idExpression);
            this.trainedModelProvider.expandIds(idExpression, request.isAllowNoResources(), request.getPageParams(), Collections.emptySet(), modelAliasMetadata, parentTaskId, matchedDeploymentIds, (ActionListener<Tuple<Long, Map<String, Set<String>>>>)l);
        }).andThenAccept(tuple -> responseBuilder.setExpandedModelIdsWithAliases((Map)tuple.v2()).setTotalModelCount(((Long)tuple.v1()).longValue())).andThen((l, ignored) -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportNodesStatsAction.TYPE, (ActionRequest)TransportGetTrainedModelsStatsAction.nodeStatsRequest(this.clusterService.state(), parentTaskId), (ActionListener)l)).andThen(this.executor, null, (l, nodesStatsResponse) -> {
            Set allPossiblePipelineReferences = responseBuilder.getExpandedModelIdsWithAliases().entrySet().stream().flatMap(entry -> Stream.concat(((Set)entry.getValue()).stream(), Stream.of((String)entry.getKey()))).collect(Collectors.toSet());
            allPossiblePipelineReferences.addAll(matchedDeploymentIds);
            Map pipelineIdsByResource = InferenceProcessorInfoExtractor.pipelineIdsByResource((ClusterState)this.clusterService.state(), allPossiblePipelineReferences);
            Map<String, IngestStats> modelIdIngestStats = TransportGetTrainedModelsStatsAction.inferenceIngestStatsByModelId(nodesStatsResponse, modelAliasMetadata, pipelineIdsByResource);
            responseBuilder.setIngestStatsByModelId(modelIdIngestStats);
            this.trainedModelProvider.getInferenceStats(responseBuilder.getExpandedModelIdsWithAliases().keySet().toArray(new String[0]), parentTaskId, (ActionListener<List<InferenceStats>>)l);
        }).andThenAccept(inferenceStats -> responseBuilder.setInferenceStatsByModelId(inferenceStats.stream().collect(Collectors.toMap(InferenceStats::getModelId, Function.identity())))).andThen(this.executor, null, (l, ignored) -> TransportGetTrainedModelsStatsAction.getDeploymentStats(this.client, request.getResourceId(), parentTaskId, assignmentMetadata, (ActionListener<GetDeploymentStatsAction.Response>)l)).andThenApply(deploymentStats -> {
            responseBuilder.setDeploymentStatsByDeploymentId(deploymentStats.getStats().results().stream().collect(Collectors.toMap(AssignmentStats::getDeploymentId, Function.identity())));
            return deploymentStats.getStats().results().stream().mapToInt(AssignmentStats::getNumberOfAllocations).sum();
        }).andThen(this.executor, null, (l, numberOfAllocations) -> this.modelSizeStats(responseBuilder.getExpandedModelIdsWithAliases(), request.isAllowNoResources(), parentTaskId, (ActionListener<Map<String, TrainedModelSizeStats>>)l, (int)numberOfAllocations)).andThenAccept(arg_0 -> ((GetTrainedModelsStatsAction.Response.Builder)responseBuilder).setModelSizeStatsByModelId(arg_0)).andThenApply(ignored -> responseBuilder.build(TransportGetTrainedModelsStatsAction.modelToDeployments(responseBuilder.getExpandedModelIdsWithAliases().keySet(), assignmentMetadata))).addListener(listener, this.executor, null);
    }

    static String addModelsUsedInMatchingDeployments(String idExpression, TrainedModelAssignmentMetadata assignmentMetadata) {
        if (Strings.isAllOrWildcard((String)idExpression)) {
            return idExpression;
        }
        HashSet<String> tokens = new HashSet<String>(Arrays.asList(ExpandedIdsMatcher.tokenizeExpression((String)idExpression)));
        Set<String> modelsUsedByMatchingDeployments = TransportGetTrainedModelsStatsAction.modelsUsedByMatchingDeploymentId(idExpression, assignmentMetadata);
        tokens.addAll(modelsUsedByMatchingDeployments);
        return String.join((CharSequence)",", tokens);
    }

    static Map<String, Set<String>> modelToDeployments(Set<String> modelIds, TrainedModelAssignmentMetadata assignments) {
        HashMap<String, Set<String>> modelToDeploymentMap = new HashMap<String, Set<String>>();
        for (TrainedModelAssignment assignment : assignments.allAssignments().values()) {
            if (!modelIds.contains(assignment.getModelId())) continue;
            modelToDeploymentMap.computeIfAbsent(assignment.getModelId(), k -> new HashSet()).add(assignment.getDeploymentId());
        }
        return modelToDeploymentMap;
    }

    static Set<String> matchedDeploymentIds(String resourceId, TrainedModelAssignmentMetadata assignments) {
        HashSet<String> deploymentIds = new HashSet<String>();
        ExpandedIdsMatcher.SimpleIdsMatcher matcher = new ExpandedIdsMatcher.SimpleIdsMatcher(resourceId);
        for (TrainedModelAssignment assignment : assignments.allAssignments().values()) {
            if (!matcher.idMatches(assignment.getDeploymentId())) continue;
            deploymentIds.add(assignment.getDeploymentId());
        }
        return deploymentIds;
    }

    static Set<String> modelsUsedByMatchingDeploymentId(String resourceId, TrainedModelAssignmentMetadata assignments) {
        HashSet<String> modelIds = new HashSet<String>();
        ExpandedIdsMatcher.SimpleIdsMatcher matcher = new ExpandedIdsMatcher.SimpleIdsMatcher(resourceId);
        for (TrainedModelAssignment assignment : assignments.allAssignments().values()) {
            if (!matcher.idMatches(assignment.getDeploymentId())) continue;
            modelIds.add(assignment.getModelId());
        }
        return modelIds;
    }

    static void getDeploymentStats(Client client, String resourceId, TaskId parentTaskId, TrainedModelAssignmentMetadata assignments, ActionListener<GetDeploymentStatsAction.Response> deploymentStatsListener) {
        ExpandedIdsMatcher.SimpleIdsMatcher matcher = new ExpandedIdsMatcher.SimpleIdsMatcher(resourceId);
        HashSet<String> matchedDeployments = new HashSet<String>();
        for (TrainedModelAssignment assignment : assignments.allAssignments().values()) {
            if (matcher.idMatches(assignment.getDeploymentId())) {
                matchedDeployments.add(assignment.getDeploymentId());
                continue;
            }
            if (!matcher.idMatches(assignment.getModelId())) continue;
            matchedDeployments.add(assignment.getDeploymentId());
        }
        String deployments = String.join((CharSequence)",", matchedDeployments);
        logger.debug("Fetching stats for deployments [{}]", (Object)deployments);
        GetDeploymentStatsAction.Request getDeploymentStatsRequest = new GetDeploymentStatsAction.Request(deployments);
        getDeploymentStatsRequest.setParentTask(parentTaskId);
        ClientHelper.executeAsyncWithOrigin((Client)client, (String)"ml", (ActionType)GetDeploymentStatsAction.INSTANCE, (ActionRequest)getDeploymentStatsRequest, deploymentStatsListener);
    }

    private void modelSizeStats(Map<String, Set<String>> expandedIdsWithAliases, boolean allowNoResources, TaskId parentTaskId, ActionListener<Map<String, TrainedModelSizeStats>> listener, int numberOfAllocations) {
        ActionListener modelsListener = ActionListener.wrap(models -> {
            List<String> pytorchModelIds = models.stream().filter(m -> m.getModelType() == TrainedModelType.PYTORCH).map(TrainedModelConfig::getModelId).toList();
            this.definitionLengths(pytorchModelIds, parentTaskId, (ActionListener<Map<String, Long>>)ActionListener.wrap(pytorchTotalDefinitionLengthsByModelId -> {
                HashMap<String, TrainedModelSizeStats> modelSizeStatsByModelId = new HashMap<String, TrainedModelSizeStats>();
                for (TrainedModelConfig model : models) {
                    if (model.getModelType() == TrainedModelType.PYTORCH) {
                        long totalDefinitionLength = pytorchTotalDefinitionLengthsByModelId.getOrDefault(model.getModelId(), 0L);
                        boolean useNewMemoryFields = TrainedModelAssignment.useNewMemoryFields((TransportVersion)TransportVersionUtils.getMinTransportVersion((ClusterState)this.clusterService.state()));
                        long estimatedMemoryUsageBytes = totalDefinitionLength > 0L ? StartTrainedModelDeploymentAction.estimateMemoryUsageBytes((String)model.getModelId(), (long)totalDefinitionLength, (long)(useNewMemoryFields ? model.getPerDeploymentMemoryBytes() : 0L), (long)(useNewMemoryFields ? model.getPerAllocationMemoryBytes() : 0L), (int)numberOfAllocations) : 0L;
                        modelSizeStatsByModelId.put(model.getModelId(), new TrainedModelSizeStats(totalDefinitionLength, estimatedMemoryUsageBytes));
                        continue;
                    }
                    modelSizeStatsByModelId.put(model.getModelId(), new TrainedModelSizeStats(model.getModelSize(), 0L));
                }
                listener.onResponse(modelSizeStatsByModelId);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        this.trainedModelProvider.getTrainedModels(expandedIdsWithAliases, GetTrainedModelsAction.Includes.empty(), allowNoResources, parentTaskId, (ActionListener<List<TrainedModelConfig>>)modelsListener);
    }

    private void definitionLengths(List<String> modelIds, TaskId parentTaskId, ActionListener<Map<String, Long>> listener) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)InferenceIndexConstants.DOC_TYPE.getPreferredName(), (String)"trained_model_definition_doc")).filter((QueryBuilder)QueryBuilders.termsQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), modelIds)).filter((QueryBuilder)QueryBuilders.termQuery((String)TrainedModelDefinitionDoc.DOC_NUM.getPreferredName(), (int)0));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".ml-inference-*"}).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)).setFetchSource(false).addDocValueField(TrainedModelConfig.MODEL_ID.getPreferredName()).addDocValueField(TrainedModelDefinitionDoc.TOTAL_DEFINITION_LENGTH.getPreferredName()).addSort("_index", SortOrder.DESC).request();
        searchRequest.setParentTask(parentTaskId);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            HashMap<String, Long> totalDefinitionLengthByModelId = new HashMap<String, Long>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                Object patt19225$temp;
                Object patt18906$temp;
                DocumentField modelIdField = hit.field(TrainedModelConfig.MODEL_ID.getPreferredName());
                if (modelIdField == null || !((patt18906$temp = modelIdField.getValue()) instanceof String)) continue;
                String modelId = (String)patt18906$temp;
                DocumentField totalDefinitionLengthField = hit.field(TrainedModelDefinitionDoc.TOTAL_DEFINITION_LENGTH.getPreferredName());
                if (totalDefinitionLengthField == null || !((patt19225$temp = totalDefinitionLengthField.getValue()) instanceof Long)) continue;
                Long totalDefinitionLength = (Long)patt19225$temp;
                totalDefinitionLengthByModelId.put(modelId, totalDefinitionLength);
            }
            listener.onResponse(totalDefinitionLengthByModelId);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static Map<String, IngestStats> inferenceIngestStatsByModelId(NodesStatsResponse response, ModelAliasMetadata currentMetadata, Map<String, Set<String>> modelIdToPipelineId) {
        HashMap<String, IngestStats> ingestStatsMap = new HashMap<String, IngestStats>();
        Map<String, Set> trueModelIdToPipelines = modelIdToPipelineId.entrySet().stream().collect(Collectors.toMap(entry -> {
            String maybeModelId = currentMetadata.getModelId((String)entry.getKey());
            return maybeModelId == null ? (String)entry.getKey() : maybeModelId;
        }, Map.Entry::getValue, Sets::union));
        trueModelIdToPipelines.forEach((modelId, pipelineIds) -> {
            List<IngestStats> collectedStats = response.getNodes().stream().map(nodeStats -> TransportGetTrainedModelsStatsAction.ingestStatsForPipelineIds(nodeStats, pipelineIds)).collect(Collectors.toList());
            ingestStatsMap.put((String)modelId, TransportGetTrainedModelsStatsAction.mergeStats(collectedStats));
        });
        return ingestStatsMap;
    }

    static NodesStatsRequest nodeStatsRequest(ClusterState state, TaskId parentTaskId) {
        String[] ingestNodes = (String[])state.nodes().getIngestNodes().keySet().toArray(String[]::new);
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(ingestNodes).clear().addMetric(NodesStatsRequestParameters.Metric.INGEST.metricName());
        nodesStatsRequest.setIncludeShardsStats(false);
        nodesStatsRequest.setParentTask(parentTaskId);
        return nodesStatsRequest;
    }

    static IngestStats ingestStatsForPipelineIds(NodeStats nodeStats, Set<String> pipelineIds) {
        IngestStats fullNodeStats = nodeStats.getIngestStats();
        HashMap filteredProcessorStats = new HashMap(fullNodeStats.processorStats());
        filteredProcessorStats.keySet().retainAll(pipelineIds);
        List<IngestStats.PipelineStat> filteredPipelineStats = fullNodeStats.pipelineStats().stream().filter(pipelineStat -> pipelineIds.contains(pipelineStat.pipelineId())).collect(Collectors.toList());
        CounterMetric ingestCount = new CounterMetric();
        CounterMetric ingestTimeInMillis = new CounterMetric();
        CounterMetric ingestCurrent = new CounterMetric();
        CounterMetric ingestFailedCount = new CounterMetric();
        filteredPipelineStats.forEach(pipelineStat -> {
            IngestStats.Stats stats = pipelineStat.stats();
            ingestCount.inc(stats.ingestCount());
            ingestTimeInMillis.inc(stats.ingestTimeInMillis());
            ingestCurrent.inc(stats.ingestCurrent());
            ingestFailedCount.inc(stats.ingestFailedCount());
        });
        return new IngestStats(new IngestStats.Stats(ingestCount.count(), ingestTimeInMillis.count(), ingestCurrent.count(), ingestFailedCount.count()), filteredPipelineStats, filteredProcessorStats);
    }

    private static IngestStats mergeStats(List<IngestStats> ingestStatsList) {
        LinkedHashMap pipelineStatsAcc = Maps.newLinkedHashMapWithExpectedSize((int)ingestStatsList.size());
        LinkedHashMap processorStatsAcc = Maps.newLinkedHashMapWithExpectedSize((int)ingestStatsList.size());
        IngestStatsAccumulator totalStats = new IngestStatsAccumulator();
        ingestStatsList.forEach(ingestStats -> {
            ingestStats.pipelineStats().forEach(pipelineStat -> pipelineStatsAcc.computeIfAbsent(pipelineStat.pipelineId(), p -> new PipelineStatsAccumulator()).inc((IngestStats.PipelineStat)pipelineStat));
            ingestStats.processorStats().forEach((pipelineId, processorStat) -> {
                Map processorAcc = processorStatsAcc.computeIfAbsent(pipelineId, k -> new LinkedHashMap());
                processorStat.forEach(p -> processorAcc.computeIfAbsent(p.name(), k -> new IngestStatsAccumulator(p.type())).inc(p.stats()));
            });
            totalStats.inc(ingestStats.totalStats());
        });
        ArrayList pipelineStatList = new ArrayList(pipelineStatsAcc.size());
        pipelineStatsAcc.forEach((pipelineId, accumulator) -> pipelineStatList.add(new IngestStats.PipelineStat(pipelineId, accumulator.buildStats(), accumulator.buildByteStats())));
        LinkedHashMap processorStatList = Maps.newLinkedHashMapWithExpectedSize((int)processorStatsAcc.size());
        processorStatsAcc.forEach((pipelineId, accumulatorMap) -> {
            ArrayList processorStats = new ArrayList(accumulatorMap.size());
            accumulatorMap.forEach((processorName, acc) -> processorStats.add(new IngestStats.ProcessorStat(processorName, acc.type, acc.build())));
            processorStatList.put(pipelineId, processorStats);
        });
        return new IngestStats(totalStats.build(), pipelineStatList, (Map)processorStatList);
    }

    private static class IngestStatsAccumulator {
        CounterMetric ingestCount = new CounterMetric();
        CounterMetric ingestTimeInMillis = new CounterMetric();
        CounterMetric ingestCurrent = new CounterMetric();
        CounterMetric ingestFailedCount = new CounterMetric();
        String type;

        IngestStatsAccumulator() {
        }

        IngestStatsAccumulator(String type) {
            this.type = type;
        }

        void inc(IngestStats.Stats s) {
            this.ingestCount.inc(s.ingestCount());
            this.ingestTimeInMillis.inc(s.ingestTimeInMillis());
            this.ingestCurrent.inc(s.ingestCurrent());
            this.ingestFailedCount.inc(s.ingestFailedCount());
        }

        IngestStats.Stats build() {
            return new IngestStats.Stats(this.ingestCount.count(), this.ingestTimeInMillis.count(), this.ingestCurrent.count(), this.ingestFailedCount.count());
        }
    }

    private static class PipelineStatsAccumulator {
        IngestStatsAccumulator ingestStatsAccumulator = new IngestStatsAccumulator();
        CounterMetric ingestBytesConsumed = new CounterMetric();
        CounterMetric ingestBytesProduced = new CounterMetric();

        private PipelineStatsAccumulator() {
        }

        void inc(IngestStats.PipelineStat s) {
            this.ingestStatsAccumulator.inc(s.stats());
            this.ingestBytesConsumed.inc(s.byteStats().bytesIngested());
            this.ingestBytesProduced.inc(s.byteStats().bytesProduced());
        }

        IngestStats.Stats buildStats() {
            return this.ingestStatsAccumulator.build();
        }

        IngestStats.ByteStats buildByteStats() {
            return new IngestStats.ByteStats(this.ingestBytesConsumed.count(), this.ingestBytesProduced.count());
        }
    }
}

