/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetModelSnapshotsAction
extends HandledTransportAction<GetModelSnapshotsAction.Request, GetModelSnapshotsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetModelSnapshotsAction.class);
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;
    private final ClusterService clusterService;

    @Inject
    public TransportGetModelSnapshotsAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider, JobManager jobManager, ClusterService clusterService) {
        super("cluster:monitor/xpack/ml/job/model_snapshots/get", transportService, actionFilters, GetModelSnapshotsAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, GetModelSnapshotsAction.Request request, ActionListener<GetModelSnapshotsAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        logger.debug(() -> Strings.format((String)"Get model snapshots for job %s snapshot ID %s. from = %s, size = %s start = '%s', end='%s', sort=%s descending=%s", (Object[])new Object[]{request.getJobId(), request.getSnapshotId(), request.getPageParams().getFrom(), request.getPageParams().getSize(), request.getStart(), request.getEnd(), request.getSort(), request.getDescOrder()}));
        if (org.elasticsearch.common.Strings.isAllOrWildcard((String)request.getJobId())) {
            this.getModelSnapshots(request, parentTaskId, listener);
            return;
        }
        this.jobManager.jobExists(request.getJobId(), parentTaskId, (ActionListener<Boolean>)listener.delegateFailureAndWrap((l, ok) -> this.getModelSnapshots(request, parentTaskId, (ActionListener<GetModelSnapshotsAction.Response>)l)));
    }

    private void getModelSnapshots(GetModelSnapshotsAction.Request request, TaskId parentTaskId, ActionListener<GetModelSnapshotsAction.Response> listener) {
        this.jobResultsProvider.modelSnapshots(request.getJobId(), request.getPageParams().getFrom(), request.getPageParams().getSize(), request.getStart(), request.getEnd(), request.getSort(), request.getDescOrder(), request.getSnapshotId(), parentTaskId, page -> listener.onResponse((Object)new GetModelSnapshotsAction.Response(page)), arg_0 -> listener.onFailure(arg_0));
    }
}

