/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetCategoriesAction
extends HandledTransportAction<GetCategoriesAction.Request, GetCategoriesAction.Response> {
    private final JobResultsProvider jobResultsProvider;
    private final Client client;
    private final JobManager jobManager;
    private final ClusterService clusterService;

    @Inject
    public TransportGetCategoriesAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider, Client client, JobManager jobManager, ClusterService clusterService) {
        super("cluster:monitor/xpack/ml/job/results/categories/get", transportService, actionFilters, GetCategoriesAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.jobResultsProvider = jobResultsProvider;
        this.client = client;
        this.jobManager = jobManager;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, GetCategoriesAction.Request request, ActionListener<GetCategoriesAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        this.jobManager.jobExists(request.getJobId(), parentTaskId, (ActionListener<Boolean>)ActionListener.wrap(jobExists -> {
            Integer from = request.getPageParams() != null ? Integer.valueOf(request.getPageParams().getFrom()) : null;
            Integer size = request.getPageParams() != null ? Integer.valueOf(request.getPageParams().getSize()) : null;
            this.jobResultsProvider.categoryDefinitions(request.getJobId(), request.getCategoryId(), request.getPartitionFieldValue(), true, from, size, r -> listener.onResponse((Object)new GetCategoriesAction.Response(r)), arg_0 -> ((ActionListener)listener).onFailure(arg_0), (CancellableTask)task, parentTaskId, (Client)new ParentTaskAssigningClient(this.client, parentTaskId));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

