/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.ClientVersion;
import org.elasticsearch.xpack.sql.client.ConnectionConfiguration;
import org.elasticsearch.xpack.sql.client.JreHttpUrlConnection;
import org.elasticsearch.xpack.sql.proto.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.CoreProtocol;
import org.elasticsearch.xpack.sql.proto.MainResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.Payloads;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlClearCursorRequest;
import org.elasticsearch.xpack.sql.proto.SqlClearCursorResponse;
import org.elasticsearch.xpack.sql.proto.SqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.SqlQueryResponse;
import org.elasticsearch.xpack.sql.proto.content.ContentFactory;
import org.elasticsearch.xpack.sql.proto.core.CheckedFunction;
import org.elasticsearch.xpack.sql.proto.core.Streams;
import org.elasticsearch.xpack.sql.proto.core.TimeValue;
import org.elasticsearch.xpack.sql.proto.core.Tuple;

public class HttpClient {
    private final ConnectionConfiguration cfg;
    private final ContentFactory.ContentType requestBodyContentType;

    public HttpClient(ConnectionConfiguration cfg) {
        this.cfg = cfg;
        this.requestBodyContentType = cfg.binaryCommunication() ? ContentFactory.ContentType.CBOR : ContentFactory.ContentType.JSON;
    }

    public boolean ping(long timeoutInMs) throws SQLException {
        return this.head("/", timeoutInMs);
    }

    public MainResponse serverInfo() throws SQLException {
        return this.get("/", Payloads::parseMainResponse);
    }

    public SqlQueryResponse basicQuery(String query, int fetchSize) throws SQLException {
        return this.basicQuery(query, fetchSize, false);
    }

    public SqlQueryResponse basicQuery(String query, int fetchSize, boolean fieldMultiValueLeniency) throws SQLException {
        return this.basicQuery(query, fetchSize, fieldMultiValueLeniency, this.cfg.allowPartialSearchResults());
    }

    public SqlQueryResponse basicQuery(String query, int fetchSize, boolean fieldMultiValueLeniency, boolean allowPartialSearchResults) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(query, Collections.emptyList(), CoreProtocol.TIME_ZONE, null, fetchSize, TimeValue.timeValueMillis(this.cfg.queryTimeout()), TimeValue.timeValueMillis(this.cfg.pageTimeout()), Boolean.FALSE, null, new RequestInfo(Mode.CLI, ClientVersion.CURRENT), fieldMultiValueLeniency, false, this.cfg.binaryCommunication(), allowPartialSearchResults);
        return this.query(sqlRequest).response();
    }

    public ResponseWithWarnings<SqlQueryResponse> query(SqlQueryRequest sqlRequest) throws SQLException {
        return this.post("/_sql", sqlRequest, Payloads::parseQueryResponse);
    }

    public SqlQueryResponse nextPage(String cursor) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(cursor, TimeValue.timeValueMillis(this.cfg.queryTimeout()), TimeValue.timeValueMillis(this.cfg.pageTimeout()), new RequestInfo(Mode.CLI), this.cfg.binaryCommunication(), this.cfg.allowPartialSearchResults());
        return this.post("/_sql", sqlRequest, Payloads::parseQueryResponse).response();
    }

    public boolean queryClose(String cursor, Mode mode) throws SQLException {
        ResponseWithWarnings<SqlClearCursorResponse> response = this.post("/_sql/close", new SqlClearCursorRequest(cursor, new RequestInfo(mode), this.cfg.binaryCommunication()), Payloads::parseClearCursorResponse);
        return response.response().isSucceeded();
    }

    private <Request extends AbstractSqlRequest, Response> ResponseWithWarnings<Response> post(String path, Request request, CheckedFunction<JsonParser, Response, IOException> responseParser) throws SQLException {
        byte[] requestBytes = this.toContent(request);
        String query = "error_trace";
        Tuple response = (Tuple)AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, query, this.cfg, con -> con.request(out -> out.write(requestBytes), HttpClient::readFrom, "POST", this.requestBodyContentType.mediaTypeWithoutParameters()))).getResponseOrThrowException();
        List warnings = (List)((Function)response.v1()).apply("Warning");
        return new ResponseWithWarnings<Response>(HttpClient.fromContent(HttpClient.contentType((Function)response.v1()), (byte[])response.v2(), responseParser), warnings == null ? Collections.emptyList() : warnings);
    }

    private boolean head(String path, long timeoutInMs) throws SQLException {
        ConnectionConfiguration pingCfg = new ConnectionConfiguration(this.cfg.baseUri(), this.cfg.connectionString(), this.cfg.validateProperties(), this.cfg.binaryCommunication(), this.cfg.connectTimeout(), timeoutInMs, this.cfg.queryTimeout(), this.cfg.pageTimeout(), this.cfg.pageSize(), this.cfg.authUser(), this.cfg.authPass(), this.cfg.sslConfig(), this.cfg.proxyConfig(), false);
        try {
            return AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, "error_trace", pingCfg, JreHttpUrlConnection::head));
        }
        catch (ClientException ex) {
            throw new SQLException("Cannot ping server", ex);
        }
    }

    private <Response> Response get(String path, CheckedFunction<JsonParser, Response, IOException> responseParser) throws SQLException {
        Tuple response = (Tuple)AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, "error_trace", this.cfg, con -> con.request(null, HttpClient::readFrom, "GET"))).getResponseOrThrowException();
        return HttpClient.fromContent(HttpClient.contentType((Function)response.v1()), (byte[])response.v2(), responseParser);
    }

    private <Request extends AbstractSqlRequest> byte[] toContent(Request request) {
        byte[] byArray;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            try (JsonGenerator generator = ContentFactory.generator(this.requestBodyContentType, buffer);){
                Payloads.generate(generator, request);
            }
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new ClientException("Cannot serialize request", ex);
            }
        }
        buffer.close();
        return byArray;
    }

    private static Tuple<Function<String, List<String>>, byte[]> readFrom(InputStream inputStream, Function<String, List<String>> headers) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Streams.copy(inputStream, out);
        }
        catch (Exception ex) {
            throw new ClientException("Cannot deserialize response", ex);
        }
        return new Tuple<Function<String, List<String>>, byte[]>(headers, out.toByteArray());
    }

    private static ContentFactory.ContentType contentType(Function<String, List<String>> headers) {
        List<String> contentTypeHeaders = headers.apply("Content-Type");
        String contentType = contentTypeHeaders == null || contentTypeHeaders.isEmpty() ? null : contentTypeHeaders.get(0);
        ContentFactory.ContentType type = ContentFactory.parseMediaType(contentType);
        if (type == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + contentType);
        }
        return type;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <Response> Response fromContent(ContentFactory.ContentType type, byte[] bytesReference, CheckedFunction<JsonParser, Response, IOException> responseParser) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytesReference);){
            Response Response;
            block13: {
                JsonParser parser = ContentFactory.parser(type, stream);
                try {
                    Response = responseParser.apply(parser);
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return Response;
        }
        catch (Exception ex) {
            throw new ClientException("Cannot parse response", ex);
        }
    }

    public static class ResponseWithWarnings<R> {
        private final R response;
        private final List<String> warnings;

        ResponseWithWarnings(R response, List<String> warnings) {
            this.response = response;
            this.warnings = warnings;
        }

        public R response() {
            return this.response;
        }

        public List<String> warnings() {
            return this.warnings;
        }
    }
}

