/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli.command;

import java.sql.SQLException;
import org.elasticsearch.xpack.sql.cli.CliTerminal;
import org.elasticsearch.xpack.sql.cli.command.AbstractServerCliCommand;
import org.elasticsearch.xpack.sql.cli.command.CliSession;
import org.elasticsearch.xpack.sql.cli.command.CliSessionConfiguration;
import org.elasticsearch.xpack.sql.client.HttpClient;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.SqlQueryResponse;
import org.elasticsearch.xpack.sql.proto.formatter.SimpleFormatter;

public class ServerQueryCliCommand
extends AbstractServerCliCommand {
    @Override
    protected boolean doHandle(CliTerminal terminal, CliSession cliSession, String line) {
        SqlQueryResponse response = null;
        HttpClient cliClient = cliSession.getClient();
        try {
            CliSessionConfiguration cfg = cliSession.cfg();
            response = cliClient.basicQuery(line, cfg.getFetchSize(), cfg.isLenient(), cfg.allowPartialResults());
            SimpleFormatter formatter = new SimpleFormatter(response.columns(), response.rows(), SimpleFormatter.FormatOption.CLI);
            String data = formatter.formatWithHeader(response.columns(), response.rows());
            while (true) {
                ServerQueryCliCommand.handleText(terminal, data);
                if (response.cursor().isEmpty()) {
                    terminal.flush();
                    return true;
                }
                if (!cliSession.cfg().getFetchSeparator().equals("")) {
                    terminal.println(cliSession.cfg().getFetchSeparator());
                }
                response = cliSession.getClient().nextPage(response.cursor());
                data = formatter.formatWithoutHeader(response.rows());
            }
        }
        catch (SQLException e) {
            if ("bad_server".equals(e.getSQLState())) {
                terminal.error("Server error", e.getMessage());
            } else {
                terminal.error("Bad request", e.getMessage());
            }
            if (response != null) {
                try {
                    cliClient.queryClose(response.cursor(), Mode.CLI);
                }
                catch (SQLException ex) {
                    terminal.error("Could not close cursor", ex.getMessage());
                }
            }
            return true;
        }
    }

    private static void handleText(CliTerminal terminal, String str) {
        terminal.print(str);
    }
}

