/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;

public final class NeverCondition
implements ExecutableCondition {
    public static final String TYPE = "never";
    public static final Condition.Result RESULT_INSTANCE = new Condition.Result(null, "never", false);
    public static final NeverCondition INSTANCE = new NeverCondition();

    private NeverCondition() {
    }

    public static NeverCondition parse(String watchId, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an empty object but found [{}]", new Object[]{TYPE, watchId, parser.currentName()});
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an empty object but found [{}]", new Object[]{TYPE, watchId, parser.currentName()});
        }
        return INSTANCE;
    }

    public Condition.Result execute(WatchExecutionContext ctx) {
        return RESULT_INSTANCE;
    }

    public boolean equals(Object obj) {
        return obj instanceof NeverCondition;
    }

    public int hashCode() {
        return 0;
    }

    public String type() {
        return TYPE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().endObject();
    }
}

