/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.secrets.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.connector.secrets.ConnectorSecretsIndexService;
import org.elasticsearch.xpack.application.connector.secrets.action.DeleteConnectorSecretRequest;
import org.elasticsearch.xpack.application.connector.secrets.action.DeleteConnectorSecretResponse;

public class TransportDeleteConnectorSecretAction
extends HandledTransportAction<DeleteConnectorSecretRequest, DeleteConnectorSecretResponse> {
    private final ConnectorSecretsIndexService connectorSecretsIndexService;

    @Inject
    public TransportDeleteConnectorSecretAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/connector/secret/delete", transportService, actionFilters, DeleteConnectorSecretRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.connectorSecretsIndexService = new ConnectorSecretsIndexService(client);
    }

    protected void doExecute(Task task, DeleteConnectorSecretRequest request, ActionListener<DeleteConnectorSecretResponse> listener) {
        this.connectorSecretsIndexService.deleteSecret(request.id(), listener);
    }
}

