/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.ConnectorSyncInfo;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.ConnectorUtils;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorLastSyncStatsAction {
    public static final String NAME = "indices:data/write/xpack/connector/update_last_sync_stats";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/update_last_sync_stats");

    private UpdateConnectorLastSyncStatsAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final ConnectorSyncInfo syncInfo;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_last_sync_stats_request", false, (args, connectorId) -> {
            int i = 0;
            return new Request((String)connectorId, new ConnectorSyncInfo.Builder().setLastAccessControlSyncError((String)args[i++]).setLastAccessControlSyncScheduledAt((Instant)args[i++]).setLastAccessControlSyncStatus((ConnectorSyncStatus)((Object)((Object)args[i++]))).setLastDeletedDocumentCount((Long)args[i++]).setLastIncrementalSyncScheduledAt((Instant)args[i++]).setLastIndexedDocumentCount((Long)args[i++]).setLastSyncError((String)args[i++]).setLastSyncScheduledAt((Instant)args[i++]).setLastSyncStatus((ConnectorSyncStatus)((Object)((Object)args[i++]))).setLastSynced((Instant)args[i++]).build());
        });

        public Request(String connectorId, ConnectorSyncInfo syncInfo) {
            this.connectorId = connectorId;
            this.syncInfo = syncInfo;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.syncInfo = (ConnectorSyncInfo)in.readOptionalWriteable(ConnectorSyncInfo::new);
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public ConnectorSyncInfo getSyncInfo() {
            return this.syncInfo;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            return validationException;
        }

        public static Request fromXContentBytes(String connectorId, BytesReference source, XContentType xContentType) {
            Request request;
            block8: {
                XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
                try {
                    request = Request.fromXContent(parser, connectorId);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                    }
                }
                parser.close();
            }
            return request;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.syncInfo.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalWriteable((Writeable)this.syncInfo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.syncInfo, request.syncInfo);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.syncInfo);
        }

        static {
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_ERROR);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : ConnectorSyncStatus.connectorSyncStatus(p.text()), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_STATUS_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_DELETED_DOCUMENT_COUNT_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_INCREMENTAL_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_INCREMENTAL_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_INDEXED_DOCUMENT_COUNT_FIELD);
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_SYNC_ERROR_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : ConnectorSyncStatus.connectorSyncStatus(p.text()), ConnectorSyncInfo.LAST_SYNC_STATUS_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_SYNCED_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_SYNCED_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        }
    }
}

