/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorFiltering;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.filtering.FilteringAdvancedSnippet;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRule;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;

public class UpdateConnectorFilteringAction {
    public static final String NAME = "indices:data/write/xpack/connector/update_filtering";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/update_filtering");

    private UpdateConnectorFilteringAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        @Nullable
        private final List<ConnectorFiltering> filtering;
        @Nullable
        private final FilteringAdvancedSnippet advancedSnippet;
        @Nullable
        private final List<FilteringRule> rules;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_filtering_request", false, (args, connectorId) -> new Request((String)connectorId, (List)args[0], (FilteringAdvancedSnippet)args[1], (List)args[2]));

        public Request(String connectorId, List<ConnectorFiltering> filtering, FilteringAdvancedSnippet advancedSnippet, List<FilteringRule> rules) {
            this.connectorId = connectorId;
            this.filtering = filtering;
            this.advancedSnippet = advancedSnippet;
            this.rules = rules;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.filtering = in.readOptionalCollectionAsList(ConnectorFiltering::new);
            this.advancedSnippet = new FilteringAdvancedSnippet(in);
            this.rules = in.readCollectionAsList(FilteringRule::new);
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public List<ConnectorFiltering> getFiltering() {
            return this.filtering;
        }

        public FilteringAdvancedSnippet getAdvancedSnippet() {
            return this.advancedSnippet;
        }

        public List<FilteringRule> getRules() {
            return this.rules;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            if (this.filtering == null) {
                if (this.rules == null && this.advancedSnippet == null) {
                    validationException = ValidateActions.addValidationError((String)"[advanced_snippet] and [rules] cannot be both [null].", (ActionRequestValidationException)validationException);
                } else if (this.rules != null) {
                    if (this.rules.isEmpty()) {
                        validationException = ValidateActions.addValidationError((String)"[rules] cannot be an empty list.", (ActionRequestValidationException)validationException);
                    } else if (!ConnectorFiltering.isDefaultRulePresentInFilteringRules(this.rules)) {
                        validationException = ValidateActions.addValidationError((String)"[rules] need to include the default filtering rule.", (ActionRequestValidationException)validationException);
                    }
                }
            } else if (this.rules != null || this.advancedSnippet != null) {
                validationException = ValidateActions.addValidationError((String)"If [filtering] is specified, [rules] and [advanced_snippet] should not be present in the request body.", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContentBytes(String connectorId, BytesReference source, XContentType xContentType) {
            Request request;
            block8: {
                XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
                try {
                    request = Request.fromXContent(parser, connectorId);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                    }
                }
                parser.close();
            }
            return request;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.FILTERING_FIELD.getPreferredName(), this.filtering);
            builder.field(FilteringRules.ADVANCED_SNIPPET_FIELD.getPreferredName(), (ToXContent)this.advancedSnippet);
            builder.xContentList(FilteringRules.RULES_FIELD.getPreferredName(), this.rules);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalCollection(this.filtering);
            this.advancedSnippet.writeTo(out);
            out.writeCollection(this.rules);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.filtering, request.filtering) && Objects.equals(this.advancedSnippet, request.advancedSnippet) && Objects.equals(this.rules, request.rules);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.filtering, this.advancedSnippet, this.rules);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorFiltering.fromXContent(p), Connector.FILTERING_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FilteringAdvancedSnippet.fromXContent(p), FilteringRules.ADVANCED_SNIPPET_FIELD);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FilteringRule.fromXContent(p), FilteringRules.RULES_FIELD);
        }
    }
}

