/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.connector.ConnectorFiltering;
import org.elasticsearch.xpack.application.connector.ConnectorIndexService;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorFilteringAction;
import org.elasticsearch.xpack.application.connector.filtering.FilteringAdvancedSnippet;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRule;

public class TransportUpdateConnectorFilteringAction
extends HandledTransportAction<UpdateConnectorFilteringAction.Request, ConnectorUpdateActionResponse> {
    protected final ConnectorIndexService connectorIndexService;

    @Inject
    public TransportUpdateConnectorFilteringAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("indices:data/write/xpack/connector/update_filtering", transportService, actionFilters, UpdateConnectorFilteringAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.connectorIndexService = new ConnectorIndexService(client);
    }

    protected void doExecute(Task task, UpdateConnectorFilteringAction.Request request, ActionListener<ConnectorUpdateActionResponse> listener) {
        String connectorId = request.getConnectorId();
        List<ConnectorFiltering> filtering = request.getFiltering();
        FilteringAdvancedSnippet advancedSnippet = request.getAdvancedSnippet();
        List<FilteringRule> rules = request.getRules();
        if (request.getFiltering() == null) {
            this.connectorIndexService.updateConnectorFilteringDraft(connectorId, advancedSnippet, rules, (ActionListener<UpdateResponse>)listener.map(r -> new ConnectorUpdateActionResponse(r.getResult())));
        } else {
            this.connectorIndexService.updateConnectorFiltering(connectorId, filtering, (ActionListener<UpdateResponse>)listener.map(r -> new ConnectorUpdateActionResponse(r.getResult())));
        }
    }
}

