/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.connector.ConnectorIndexService;
import org.elasticsearch.xpack.application.connector.action.ListConnectorAction;
import org.elasticsearch.xpack.core.action.util.PageParams;

public class TransportListConnectorAction
extends HandledTransportAction<ListConnectorAction.Request, ListConnectorAction.Response> {
    protected final ConnectorIndexService connectorIndexService;

    @Inject
    public TransportListConnectorAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("indices:data/read/xpack/connector/list", transportService, actionFilters, ListConnectorAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.connectorIndexService = new ConnectorIndexService(client);
    }

    protected void doExecute(Task task, ListConnectorAction.Request request, ActionListener<ListConnectorAction.Response> listener) {
        PageParams pageParams = request.getPageParams();
        this.connectorIndexService.listConnectors(pageParams.getFrom(), pageParams.getSize(), request.getIndexNames(), request.getConnectorNames(), request.getConnectorServiceTypes(), request.getConnectorSearchQuery(), (ActionListener<ConnectorIndexService.ConnectorResult>)listener.map(r -> new ListConnectorAction.Response(r.connectors(), r.totalResults())));
    }
}

