/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class ConnectorFeatures
implements Writeable,
ToXContentObject {
    @Nullable
    private final FeatureEnabled documentLevelSecurityEnabled;
    @Nullable
    private final Boolean filteringAdvancedConfigEnabled;
    @Nullable
    private final Boolean filteringRulesEnabled;
    @Nullable
    private final FeatureEnabled incrementalSyncEnabled;
    @Nullable
    private final FeatureEnabled nativeConnectorAPIKeysEnabled;
    @Nullable
    private final SyncRulesFeatures syncRulesFeatures;
    private static final ParseField DOCUMENT_LEVEL_SECURITY_ENABLED_FIELD = new ParseField("document_level_security", new String[0]);
    private static final ParseField FILTERING_ADVANCED_CONFIG_ENABLED_FIELD = new ParseField("filtering_advanced_config", new String[0]);
    private static final ParseField FILTERING_RULES_ENABLED_FIELD = new ParseField("filtering_rules", new String[0]);
    private static final ParseField INCREMENTAL_SYNC_ENABLED_FIELD = new ParseField("incremental_sync", new String[0]);
    private static final ParseField NATIVE_CONNECTOR_API_KEYS_ENABLED_FIELD = new ParseField("native_connector_api_keys", new String[0]);
    private static final ParseField SYNC_RULES_FIELD = new ParseField("sync_rules", new String[0]);
    private static final ConstructingObjectParser<ConnectorFeatures, Void> PARSER = new ConstructingObjectParser("connector_features", true, args -> new Builder().setDocumentLevelSecurityEnabled((FeatureEnabled)args[0]).setFilteringAdvancedConfig((Boolean)args[1]).setFilteringRules((Boolean)args[2]).setIncrementalSyncEnabled((FeatureEnabled)args[3]).setNativeConnectorAPIKeysEnabled((FeatureEnabled)args[4]).setSyncRulesFeatures((SyncRulesFeatures)args[5]).build());

    private ConnectorFeatures(FeatureEnabled documentLevelSecurityEnabled, Boolean filteringAdvancedConfig, Boolean filteringRules, FeatureEnabled incrementalSyncEnabled, FeatureEnabled nativeConnectorAPIKeysEnabled, SyncRulesFeatures syncRulesFeatures) {
        this.documentLevelSecurityEnabled = documentLevelSecurityEnabled;
        this.filteringAdvancedConfigEnabled = filteringAdvancedConfig;
        this.filteringRulesEnabled = filteringRules;
        this.incrementalSyncEnabled = incrementalSyncEnabled;
        this.nativeConnectorAPIKeysEnabled = nativeConnectorAPIKeysEnabled;
        this.syncRulesFeatures = syncRulesFeatures;
    }

    public ConnectorFeatures(StreamInput in) throws IOException {
        this.documentLevelSecurityEnabled = (FeatureEnabled)in.readOptionalWriteable(FeatureEnabled::new);
        this.filteringAdvancedConfigEnabled = in.readOptionalBoolean();
        this.filteringRulesEnabled = in.readOptionalBoolean();
        this.incrementalSyncEnabled = (FeatureEnabled)in.readOptionalWriteable(FeatureEnabled::new);
        this.nativeConnectorAPIKeysEnabled = (FeatureEnabled)in.readOptionalWriteable(FeatureEnabled::new);
        this.syncRulesFeatures = (SyncRulesFeatures)in.readOptionalWriteable(SyncRulesFeatures::new);
    }

    public static ConnectorFeatures fromXContent(XContentParser parser) throws IOException {
        return (ConnectorFeatures)PARSER.parse(parser, null);
    }

    public static ConnectorFeatures fromXContentBytes(BytesReference source, XContentType xContentType) {
        ConnectorFeatures connectorFeatures;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connectorFeatures = ConnectorFeatures.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector features.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connectorFeatures;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.documentLevelSecurityEnabled != null) {
            builder.field(DOCUMENT_LEVEL_SECURITY_ENABLED_FIELD.getPreferredName(), (ToXContent)this.documentLevelSecurityEnabled);
        }
        if (this.filteringAdvancedConfigEnabled != null) {
            builder.field(FILTERING_ADVANCED_CONFIG_ENABLED_FIELD.getPreferredName(), this.filteringAdvancedConfigEnabled);
        }
        if (this.filteringRulesEnabled != null) {
            builder.field(FILTERING_RULES_ENABLED_FIELD.getPreferredName(), this.filteringRulesEnabled);
        }
        if (this.incrementalSyncEnabled != null) {
            builder.field(INCREMENTAL_SYNC_ENABLED_FIELD.getPreferredName(), (ToXContent)this.incrementalSyncEnabled);
        }
        if (this.nativeConnectorAPIKeysEnabled != null) {
            builder.field(NATIVE_CONNECTOR_API_KEYS_ENABLED_FIELD.getPreferredName(), (ToXContent)this.nativeConnectorAPIKeysEnabled);
        }
        if (this.syncRulesFeatures != null) {
            builder.field(SYNC_RULES_FIELD.getPreferredName(), (ToXContent)this.syncRulesFeatures);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.documentLevelSecurityEnabled);
        out.writeOptionalBoolean(this.filteringAdvancedConfigEnabled);
        out.writeOptionalBoolean(this.filteringRulesEnabled);
        out.writeOptionalWriteable((Writeable)this.incrementalSyncEnabled);
        out.writeOptionalWriteable((Writeable)this.nativeConnectorAPIKeysEnabled);
        out.writeOptionalWriteable((Writeable)this.syncRulesFeatures);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorFeatures features = (ConnectorFeatures)o;
        return Objects.equals(this.documentLevelSecurityEnabled, features.documentLevelSecurityEnabled) && Objects.equals(this.filteringAdvancedConfigEnabled, features.filteringAdvancedConfigEnabled) && Objects.equals(this.filteringRulesEnabled, features.filteringRulesEnabled) && Objects.equals(this.incrementalSyncEnabled, features.incrementalSyncEnabled) && Objects.equals(this.nativeConnectorAPIKeysEnabled, features.nativeConnectorAPIKeysEnabled) && Objects.equals(this.syncRulesFeatures, features.syncRulesFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.documentLevelSecurityEnabled, this.filteringAdvancedConfigEnabled, this.filteringRulesEnabled, this.incrementalSyncEnabled, this.nativeConnectorAPIKeysEnabled, this.syncRulesFeatures);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FeatureEnabled.fromXContent(p), DOCUMENT_LEVEL_SECURITY_ENABLED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FILTERING_ADVANCED_CONFIG_ENABLED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FILTERING_RULES_ENABLED_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FeatureEnabled.fromXContent(p), INCREMENTAL_SYNC_ENABLED_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FeatureEnabled.fromXContent(p), NATIVE_CONNECTOR_API_KEYS_ENABLED_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SyncRulesFeatures.fromXContent(p), SYNC_RULES_FIELD);
    }

    public static class FeatureEnabled
    implements ToXContentObject,
    Writeable {
        private final boolean enabled;
        private static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
        private static final ConstructingObjectParser<FeatureEnabled, Void> PARSER = new ConstructingObjectParser("connector_feature_enabled", true, args -> new FeatureEnabled((Boolean)args[0]));

        public FeatureEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public FeatureEnabled(StreamInput in) throws IOException {
            this.enabled = in.readBoolean();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
            builder.endObject();
            return builder;
        }

        public static FeatureEnabled fromXContent(XContentParser parser) throws IOException {
            return (FeatureEnabled)PARSER.parse(parser, null);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.enabled);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureEnabled that = (FeatureEnabled)o;
            return this.enabled == that.enabled;
        }

        public int hashCode() {
            return Objects.hash(this.enabled);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
        }
    }

    public static class SyncRulesFeatures
    implements ToXContentObject,
    Writeable {
        private final FeatureEnabled syncRulesAdvancedEnabled;
        private final FeatureEnabled syncRulesBasicEnabled;
        private static final ParseField SYNC_RULES_ADVANCED_ENABLED_FIELD = new ParseField("advanced", new String[0]);
        private static final ParseField SYNC_RULES_BASIC_ENABLED_FIELD = new ParseField("basic", new String[0]);
        private static final ConstructingObjectParser<SyncRulesFeatures, Void> PARSER = new ConstructingObjectParser("sync_rules_features", true, args -> new Builder().setSyncRulesAdvancedEnabled((FeatureEnabled)args[0]).setSyncRulesBasicEnabled((FeatureEnabled)args[1]).build());

        private SyncRulesFeatures(FeatureEnabled syncRulesAdvancedEnabled, FeatureEnabled syncRulesBasicEnabled) {
            this.syncRulesAdvancedEnabled = syncRulesAdvancedEnabled;
            this.syncRulesBasicEnabled = syncRulesBasicEnabled;
        }

        public SyncRulesFeatures(StreamInput in) throws IOException {
            this.syncRulesAdvancedEnabled = (FeatureEnabled)in.readOptionalWriteable(FeatureEnabled::new);
            this.syncRulesBasicEnabled = (FeatureEnabled)in.readOptionalWriteable(FeatureEnabled::new);
        }

        public static SyncRulesFeatures fromXContent(XContentParser p) throws IOException {
            return (SyncRulesFeatures)PARSER.parse(p, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.syncRulesAdvancedEnabled != null) {
                builder.field(SYNC_RULES_ADVANCED_ENABLED_FIELD.getPreferredName(), (ToXContent)this.syncRulesAdvancedEnabled);
            }
            if (this.syncRulesBasicEnabled != null) {
                builder.field(SYNC_RULES_BASIC_ENABLED_FIELD.getPreferredName(), (ToXContent)this.syncRulesBasicEnabled);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.syncRulesAdvancedEnabled);
            out.writeOptionalWriteable((Writeable)this.syncRulesBasicEnabled);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SyncRulesFeatures that = (SyncRulesFeatures)o;
            return Objects.equals(this.syncRulesAdvancedEnabled, that.syncRulesAdvancedEnabled) && Objects.equals(this.syncRulesBasicEnabled, that.syncRulesBasicEnabled);
        }

        public int hashCode() {
            return Objects.hash(this.syncRulesAdvancedEnabled, this.syncRulesBasicEnabled);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FeatureEnabled.fromXContent(p), SYNC_RULES_ADVANCED_ENABLED_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FeatureEnabled.fromXContent(p), SYNC_RULES_BASIC_ENABLED_FIELD);
        }

        public static class Builder {
            private FeatureEnabled syncRulesAdvancedEnabled;
            private FeatureEnabled syncRulesBasicEnabled;

            public Builder setSyncRulesAdvancedEnabled(FeatureEnabled syncRulesAdvancedEnabled) {
                this.syncRulesAdvancedEnabled = syncRulesAdvancedEnabled;
                return this;
            }

            public Builder setSyncRulesBasicEnabled(FeatureEnabled syncRulesBasicEnabled) {
                this.syncRulesBasicEnabled = syncRulesBasicEnabled;
                return this;
            }

            public SyncRulesFeatures build() {
                return new SyncRulesFeatures(this.syncRulesAdvancedEnabled, this.syncRulesBasicEnabled);
            }
        }
    }

    public static class Builder {
        private FeatureEnabled documentLevelSecurityEnabled;
        private Boolean filteringAdvancedConfig;
        private Boolean filteringRules;
        private FeatureEnabled incrementalSyncEnabled;
        private FeatureEnabled nativeConnectorAPIKeysEnabled;
        private SyncRulesFeatures syncRulesFeatures;

        public Builder setDocumentLevelSecurityEnabled(FeatureEnabled documentLevelSecurityEnabled) {
            this.documentLevelSecurityEnabled = documentLevelSecurityEnabled;
            return this;
        }

        public Builder setFilteringAdvancedConfig(Boolean filteringAdvancedConfig) {
            this.filteringAdvancedConfig = filteringAdvancedConfig;
            return this;
        }

        public Builder setFilteringRules(Boolean filteringRules) {
            this.filteringRules = filteringRules;
            return this;
        }

        public Builder setIncrementalSyncEnabled(FeatureEnabled incrementalSyncEnabled) {
            this.incrementalSyncEnabled = incrementalSyncEnabled;
            return this;
        }

        public Builder setNativeConnectorAPIKeysEnabled(FeatureEnabled nativeConnectorAPIKeysEnabled) {
            this.nativeConnectorAPIKeysEnabled = nativeConnectorAPIKeysEnabled;
            return this;
        }

        public Builder setSyncRulesFeatures(SyncRulesFeatures syncRulesFeatures) {
            this.syncRulesFeatures = syncRulesFeatures;
            return this;
        }

        public ConnectorFeatures build() {
            return new ConnectorFeatures(this.documentLevelSecurityEnabled, this.filteringAdvancedConfig, this.filteringRules, this.incrementalSyncEnabled, this.nativeConnectorAPIKeysEnabled, this.syncRulesFeatures);
        }
    }
}

