/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.EnterpriseSearchInfoTransportAction;
import org.elasticsearch.xpack.application.EnterpriseSearchUsageTransportAction;
import org.elasticsearch.xpack.application.analytics.AnalyticsTemplateRegistry;
import org.elasticsearch.xpack.application.analytics.action.DeleteAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.GetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.PostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.action.PutAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.RestDeleteAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.RestGetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.RestPostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.action.RestPutAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.TransportDeleteAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.TransportGetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.TransportPostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.action.TransportPutAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.ingest.AnalyticsEventIngestConfig;
import org.elasticsearch.xpack.application.connector.ConnectorAPIFeature;
import org.elasticsearch.xpack.application.connector.ConnectorTemplateRegistry;
import org.elasticsearch.xpack.application.connector.action.DeleteConnectorAction;
import org.elasticsearch.xpack.application.connector.action.GetConnectorAction;
import org.elasticsearch.xpack.application.connector.action.ListConnectorAction;
import org.elasticsearch.xpack.application.connector.action.PostConnectorAction;
import org.elasticsearch.xpack.application.connector.action.PutConnectorAction;
import org.elasticsearch.xpack.application.connector.action.RestDeleteConnectorAction;
import org.elasticsearch.xpack.application.connector.action.RestGetConnectorAction;
import org.elasticsearch.xpack.application.connector.action.RestListConnectorAction;
import org.elasticsearch.xpack.application.connector.action.RestPostConnectorAction;
import org.elasticsearch.xpack.application.connector.action.RestPutConnectorAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorActiveFilteringAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorApiKeyIdAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorConfigurationAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorErrorAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorFilteringAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorFilteringValidationAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorIndexNameAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorLastSeenAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorLastSyncStatsAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorNameAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorNativeAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorPipelineAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorSchedulingAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorServiceTypeAction;
import org.elasticsearch.xpack.application.connector.action.RestUpdateConnectorStatusAction;
import org.elasticsearch.xpack.application.connector.action.TransportDeleteConnectorAction;
import org.elasticsearch.xpack.application.connector.action.TransportGetConnectorAction;
import org.elasticsearch.xpack.application.connector.action.TransportListConnectorAction;
import org.elasticsearch.xpack.application.connector.action.TransportPostConnectorAction;
import org.elasticsearch.xpack.application.connector.action.TransportPutConnectorAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorActiveFilteringAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorApiKeyIdAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorConfigurationAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorErrorAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorFilteringAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorFilteringValidationAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorIndexNameAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorLastSeenAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorLastSyncStatsAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorNameAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorNativeAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorPipelineAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorSchedulingAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorServiceTypeAction;
import org.elasticsearch.xpack.application.connector.action.TransportUpdateConnectorStatusAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorActiveFilteringAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorApiKeyIdAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorConfigurationAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorErrorAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorFilteringAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorFilteringValidationAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorIndexNameAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorLastSeenAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorLastSyncStatsAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorNameAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorNativeAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorPipelineAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorSchedulingAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorServiceTypeAction;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorStatusAction;
import org.elasticsearch.xpack.application.connector.secrets.ConnectorSecretsFeature;
import org.elasticsearch.xpack.application.connector.secrets.ConnectorSecretsIndexService;
import org.elasticsearch.xpack.application.connector.secrets.action.DeleteConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.GetConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.PostConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.PutConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.RestDeleteConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.RestGetConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.RestPostConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.RestPutConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.TransportDeleteConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.TransportGetConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.TransportPostConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.TransportPutConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.CancelConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.CheckInConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.DeleteConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.GetConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.ListConnectorSyncJobsAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.PostConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.RestCancelConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.RestCheckInConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.RestDeleteConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.RestGetConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.RestListConnectorSyncJobsAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.RestPostConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.RestUpdateConnectorSyncJobErrorAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.RestUpdateConnectorSyncJobIngestionStatsAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.TransportCancelConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.TransportCheckInConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.TransportDeleteConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.TransportGetConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.TransportListConnectorSyncJobsAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.TransportPostConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.TransportUpdateConnectorSyncJobErrorAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.TransportUpdateConnectorSyncJobIngestionStatsAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.UpdateConnectorSyncJobErrorAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.UpdateConnectorSyncJobIngestionStatsAction;
import org.elasticsearch.xpack.application.rules.QueryRulesConfig;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.RuleQueryBuilder;
import org.elasticsearch.xpack.application.rules.action.DeleteQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.GetQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.ListQueryRulesetsAction;
import org.elasticsearch.xpack.application.rules.action.PutQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.RestDeleteQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.RestGetQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.RestListQueryRulesetsAction;
import org.elasticsearch.xpack.application.rules.action.RestPutQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.TransportDeleteQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.TransportGetQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.TransportListQueryRulesetsAction;
import org.elasticsearch.xpack.application.rules.action.TransportPutQueryRulesetAction;
import org.elasticsearch.xpack.application.search.SearchApplicationIndexService;
import org.elasticsearch.xpack.application.search.action.DeleteSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.GetSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.ListSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.PutSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.QuerySearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RenderSearchApplicationQueryAction;
import org.elasticsearch.xpack.application.search.action.RestDeleteSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestGetSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestListSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestPutSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestQuerySearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestRenderSearchApplicationQueryAction;
import org.elasticsearch.xpack.application.search.action.TransportDeleteSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportGetSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportListSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportPutSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportQuerySearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportRenderSearchApplicationQueryAction;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;

public class EnterpriseSearch
extends Plugin
implements ActionPlugin,
SystemIndexPlugin,
SearchPlugin {
    public static final String APPLICATION_API_ENDPOINT = "_application";
    public static final String SEARCH_APPLICATION_API_ENDPOINT = "_application/search_application";
    public static final String BEHAVIORAL_ANALYTICS_API_ENDPOINT = "_application/analytics";
    public static final String QUERY_RULES_API_ENDPOINT = "_query_rules";
    public static final String CONNECTOR_API_ENDPOINT = "_connector";
    public static final String CONNECTOR_SYNC_JOB_API_ENDPOINT = "_connector/_sync_job";
    private static final Logger logger = LogManager.getLogger(EnterpriseSearch.class);
    public static final String FEATURE_NAME = "ent_search";
    private final boolean enabled;

    public EnterpriseSearch(Settings settings) {
        this.enabled = (Boolean)XPackSettings.ENTERPRISE_SEARCH_ENABLED.get(settings);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler usageAction = new ActionPlugin.ActionHandler(XPackUsageFeatureAction.ENTERPRISE_SEARCH, EnterpriseSearchUsageTransportAction.class);
        ActionPlugin.ActionHandler infoAction = new ActionPlugin.ActionHandler(XPackInfoFeatureAction.ENTERPRISE_SEARCH, EnterpriseSearchInfoTransportAction.class);
        if (!this.enabled) {
            return List.of(usageAction, infoAction);
        }
        ArrayList<ActionPlugin.ActionHandler> actionHandlers = new ArrayList<ActionPlugin.ActionHandler>(List.of(new ActionPlugin.ActionHandler(PutAnalyticsCollectionAction.INSTANCE, TransportPutAnalyticsCollectionAction.class), new ActionPlugin.ActionHandler(GetAnalyticsCollectionAction.INSTANCE, TransportGetAnalyticsCollectionAction.class), new ActionPlugin.ActionHandler(DeleteAnalyticsCollectionAction.INSTANCE, TransportDeleteAnalyticsCollectionAction.class), new ActionPlugin.ActionHandler(PostAnalyticsEventAction.INSTANCE, TransportPostAnalyticsEventAction.class), new ActionPlugin.ActionHandler(DeleteSearchApplicationAction.INSTANCE, TransportDeleteSearchApplicationAction.class), new ActionPlugin.ActionHandler(GetSearchApplicationAction.INSTANCE, TransportGetSearchApplicationAction.class), new ActionPlugin.ActionHandler(ListSearchApplicationAction.INSTANCE, TransportListSearchApplicationAction.class), new ActionPlugin.ActionHandler(PutSearchApplicationAction.INSTANCE, TransportPutSearchApplicationAction.class), new ActionPlugin.ActionHandler(QuerySearchApplicationAction.INSTANCE, TransportQuerySearchApplicationAction.class), new ActionPlugin.ActionHandler(RenderSearchApplicationQueryAction.INSTANCE, TransportRenderSearchApplicationQueryAction.class), new ActionPlugin.ActionHandler(DeleteQueryRulesetAction.INSTANCE, TransportDeleteQueryRulesetAction.class), new ActionPlugin.ActionHandler(GetQueryRulesetAction.INSTANCE, TransportGetQueryRulesetAction.class), new ActionPlugin.ActionHandler(ListQueryRulesetsAction.INSTANCE, TransportListQueryRulesetsAction.class), new ActionPlugin.ActionHandler(PutQueryRulesetAction.INSTANCE, TransportPutQueryRulesetAction.class), usageAction, infoAction));
        if (ConnectorAPIFeature.isEnabled()) {
            actionHandlers.addAll(List.of(new ActionPlugin.ActionHandler(DeleteConnectorAction.INSTANCE, TransportDeleteConnectorAction.class), new ActionPlugin.ActionHandler(GetConnectorAction.INSTANCE, TransportGetConnectorAction.class), new ActionPlugin.ActionHandler(ListConnectorAction.INSTANCE, TransportListConnectorAction.class), new ActionPlugin.ActionHandler(PostConnectorAction.INSTANCE, TransportPostConnectorAction.class), new ActionPlugin.ActionHandler(PutConnectorAction.INSTANCE, TransportPutConnectorAction.class), new ActionPlugin.ActionHandler(UpdateConnectorApiKeyIdAction.INSTANCE, TransportUpdateConnectorApiKeyIdAction.class), new ActionPlugin.ActionHandler(UpdateConnectorConfigurationAction.INSTANCE, TransportUpdateConnectorConfigurationAction.class), new ActionPlugin.ActionHandler(UpdateConnectorErrorAction.INSTANCE, TransportUpdateConnectorErrorAction.class), new ActionPlugin.ActionHandler(UpdateConnectorFilteringAction.INSTANCE, TransportUpdateConnectorFilteringAction.class), new ActionPlugin.ActionHandler(UpdateConnectorActiveFilteringAction.INSTANCE, TransportUpdateConnectorActiveFilteringAction.class), new ActionPlugin.ActionHandler(UpdateConnectorFilteringValidationAction.INSTANCE, TransportUpdateConnectorFilteringValidationAction.class), new ActionPlugin.ActionHandler(UpdateConnectorIndexNameAction.INSTANCE, TransportUpdateConnectorIndexNameAction.class), new ActionPlugin.ActionHandler(UpdateConnectorLastSeenAction.INSTANCE, TransportUpdateConnectorLastSeenAction.class), new ActionPlugin.ActionHandler(UpdateConnectorLastSyncStatsAction.INSTANCE, TransportUpdateConnectorLastSyncStatsAction.class), new ActionPlugin.ActionHandler(UpdateConnectorNameAction.INSTANCE, TransportUpdateConnectorNameAction.class), new ActionPlugin.ActionHandler(UpdateConnectorNativeAction.INSTANCE, TransportUpdateConnectorNativeAction.class), new ActionPlugin.ActionHandler(UpdateConnectorPipelineAction.INSTANCE, TransportUpdateConnectorPipelineAction.class), new ActionPlugin.ActionHandler(UpdateConnectorSchedulingAction.INSTANCE, TransportUpdateConnectorSchedulingAction.class), new ActionPlugin.ActionHandler(UpdateConnectorServiceTypeAction.INSTANCE, TransportUpdateConnectorServiceTypeAction.class), new ActionPlugin.ActionHandler(UpdateConnectorStatusAction.INSTANCE, TransportUpdateConnectorStatusAction.class), new ActionPlugin.ActionHandler(GetConnectorSyncJobAction.INSTANCE, TransportGetConnectorSyncJobAction.class), new ActionPlugin.ActionHandler(PostConnectorSyncJobAction.INSTANCE, TransportPostConnectorSyncJobAction.class), new ActionPlugin.ActionHandler(DeleteConnectorSyncJobAction.INSTANCE, TransportDeleteConnectorSyncJobAction.class), new ActionPlugin.ActionHandler(CheckInConnectorSyncJobAction.INSTANCE, TransportCheckInConnectorSyncJobAction.class), new ActionPlugin.ActionHandler(CancelConnectorSyncJobAction.INSTANCE, TransportCancelConnectorSyncJobAction.class), new ActionPlugin.ActionHandler(ListConnectorSyncJobsAction.INSTANCE, TransportListConnectorSyncJobsAction.class), new ActionPlugin.ActionHandler(UpdateConnectorSyncJobErrorAction.INSTANCE, TransportUpdateConnectorSyncJobErrorAction.class), new ActionPlugin.ActionHandler(UpdateConnectorSyncJobIngestionStatsAction.INSTANCE, TransportUpdateConnectorSyncJobIngestionStatsAction.class)));
        }
        if (ConnectorSecretsFeature.isEnabled()) {
            actionHandlers.addAll(List.of(new ActionPlugin.ActionHandler(DeleteConnectorSecretAction.INSTANCE, TransportDeleteConnectorSecretAction.class), new ActionPlugin.ActionHandler(GetConnectorSecretAction.INSTANCE, TransportGetConnectorSecretAction.class), new ActionPlugin.ActionHandler(PostConnectorSecretAction.INSTANCE, TransportPostConnectorSecretAction.class), new ActionPlugin.ActionHandler(PutConnectorSecretAction.INSTANCE, TransportPutConnectorSecretAction.class)));
        }
        return Collections.unmodifiableList(actionHandlers);
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ArrayList<EnterpriseSearchBaseRestHandler> restHandlers = new ArrayList<EnterpriseSearchBaseRestHandler>(List.of(new EnterpriseSearchBaseRestHandler[]{new RestPutAnalyticsCollectionAction(this.getLicenseState()), new RestGetAnalyticsCollectionAction(this.getLicenseState()), new RestDeleteAnalyticsCollectionAction(this.getLicenseState()), new RestPostAnalyticsEventAction(this.getLicenseState()), new RestDeleteSearchApplicationAction(this.getLicenseState()), new RestGetSearchApplicationAction(this.getLicenseState()), new RestListSearchApplicationAction(this.getLicenseState()), new RestPutSearchApplicationAction(this.getLicenseState()), new RestQuerySearchApplicationAction(this.getLicenseState()), new RestRenderSearchApplicationQueryAction(this.getLicenseState()), new RestDeleteQueryRulesetAction(this.getLicenseState()), new RestGetQueryRulesetAction(this.getLicenseState()), new RestListQueryRulesetsAction(this.getLicenseState()), new RestPutQueryRulesetAction(this.getLicenseState())}));
        if (ConnectorAPIFeature.isEnabled()) {
            restHandlers.addAll(List.of(new BaseRestHandler[]{new RestDeleteConnectorAction(), new RestGetConnectorAction(), new RestListConnectorAction(), new RestPostConnectorAction(), new RestPutConnectorAction(), new RestUpdateConnectorApiKeyIdAction(), new RestUpdateConnectorConfigurationAction(), new RestUpdateConnectorErrorAction(), new RestUpdateConnectorActiveFilteringAction(), new RestUpdateConnectorFilteringValidationAction(), new RestUpdateConnectorFilteringAction(), new RestUpdateConnectorIndexNameAction(), new RestUpdateConnectorLastSeenAction(), new RestUpdateConnectorLastSyncStatsAction(), new RestUpdateConnectorNameAction(), new RestUpdateConnectorNativeAction(), new RestUpdateConnectorPipelineAction(), new RestUpdateConnectorSchedulingAction(), new RestUpdateConnectorServiceTypeAction(), new RestUpdateConnectorStatusAction(), new RestGetConnectorSyncJobAction(), new RestPostConnectorSyncJobAction(), new RestDeleteConnectorSyncJobAction(), new RestCancelConnectorSyncJobAction(), new RestCheckInConnectorSyncJobAction(), new RestListConnectorSyncJobsAction(), new RestUpdateConnectorSyncJobErrorAction(), new RestUpdateConnectorSyncJobIngestionStatsAction()}));
        }
        if (ConnectorSecretsFeature.isEnabled()) {
            restHandlers.addAll(List.of(new RestDeleteConnectorSecretAction(), new RestGetConnectorSecretAction(), new RestPostConnectorSecretAction(), new RestPutConnectorSecretAction()));
        }
        return Collections.unmodifiableList(restHandlers);
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        AnalyticsTemplateRegistry analyticsTemplateRegistry = new AnalyticsTemplateRegistry(services.clusterService(), services.featureService(), services.threadPool(), services.client(), services.xContentRegistry());
        analyticsTemplateRegistry.initialize();
        ConnectorTemplateRegistry connectorTemplateRegistry = new ConnectorTemplateRegistry(services.clusterService(), services.featureService(), services.threadPool(), services.client(), services.xContentRegistry());
        connectorTemplateRegistry.initialize();
        return Arrays.asList(new IndexTemplateRegistry[]{analyticsTemplateRegistry, connectorTemplateRegistry});
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        ArrayList<SystemIndexDescriptor> systemIndices = new ArrayList<SystemIndexDescriptor>(List.of(SearchApplicationIndexService.getSystemIndexDescriptor(), QueryRulesIndexService.getSystemIndexDescriptor()));
        if (ConnectorSecretsFeature.isEnabled()) {
            systemIndices.add(ConnectorSecretsIndexService.getSystemIndexDescriptor());
        }
        return systemIndices;
    }

    public String getFeatureName() {
        return FEATURE_NAME;
    }

    public String getFeatureDescription() {
        return "Manages configuration for Enterprise Search features";
    }

    public List<Setting<?>> getSettings() {
        return List.of(AnalyticsEventIngestConfig.MAX_NUMBER_OF_EVENTS_PER_BULK_SETTING, AnalyticsEventIngestConfig.FLUSH_DELAY_SETTING, AnalyticsEventIngestConfig.MAX_NUMBER_OF_RETRIES_SETTING, AnalyticsEventIngestConfig.MAX_BYTES_IN_FLIGHT_SETTING, QueryRulesConfig.MAX_RULE_LIMIT_SETTING);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("rule_query", RuleQueryBuilder::new, p -> RuleQueryBuilder.fromXContent(p, this.getLicenseState())));
    }
}

