/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.versionfield;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;

class VersionEncoder {
    public static final byte NUMERIC_MARKER_BYTE = 1;
    public static final byte PRERELEASE_SEPARATOR_BYTE = 2;
    public static final byte NO_PRERELEASE_SEPARATOR_BYTE = 3;
    private static final char PRERELEASE_SEPARATOR = '-';
    private static final char DOT_SEPARATOR = '.';
    private static final char BUILD_SEPARATOR = '+';
    private static final String ENCODED_EMPTY_STRING = new String(new byte[]{3}, Charsets.UTF_8);
    private static Pattern LEGAL_MAIN_VERSION_SEMVER = Pattern.compile("(0|[1-9]\\d*)(\\.(0|[1-9]\\d*))*");
    private static Pattern LEGAL_PRERELEASE_VERSION_SEMVER = Pattern.compile("(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))");
    private static Pattern LEGAL_BUILDSUFFIX_SEMVER = Pattern.compile("(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?");

    VersionEncoder() {
    }

    public static EncodedVersion encodeVersion(String versionString) {
        VersionParts versionParts = VersionParts.ofVersion(versionString);
        if (!VersionEncoder.legalVersionString(versionParts)) {
            if (versionString.length() == 0) {
                versionString = ENCODED_EMPTY_STRING;
            }
            return new EncodedVersion(new BytesRef((CharSequence)versionString), false, true, null, null, null);
        }
        BytesRefBuilder encodedBytes = new BytesRefBuilder();
        Integer[] mainVersionParts = VersionEncoder.prefixDigitGroupsWithLength(versionParts.mainVersion, encodedBytes);
        if (versionParts.preRelease != null) {
            encodedBytes.append((byte)2);
            encodedBytes.append((byte)45);
            String[] preReleaseParts = versionParts.preRelease.substring(1).split("\\.");
            boolean first = true;
            for (String preReleasePart : preReleaseParts) {
                boolean isNumeric;
                if (!first) {
                    encodedBytes.append((byte)46);
                }
                if (isNumeric = preReleasePart.chars().allMatch(x -> Character.isDigit(x))) {
                    VersionEncoder.prefixDigitGroupsWithLength(preReleasePart, encodedBytes);
                } else {
                    encodedBytes.append(new BytesRef((CharSequence)preReleasePart));
                }
                first = false;
            }
        } else {
            encodedBytes.append((byte)3);
        }
        if (versionParts.buildSuffix != null) {
            encodedBytes.append(new BytesRef((CharSequence)versionParts.buildSuffix));
        }
        return new EncodedVersion(encodedBytes.toBytesRef(), true, versionParts.preRelease != null, mainVersionParts[0], mainVersionParts[1], mainVersionParts[2]);
    }

    private static Integer[] prefixDigitGroupsWithLength(String input, BytesRefBuilder result) {
        int pos = 0;
        int mainVersionCounter = 0;
        Integer[] mainVersionComponents = new Integer[3];
        while (pos < input.length()) {
            if (Character.isDigit(input.charAt(pos))) {
                int start = pos;
                BytesRefBuilder number = new BytesRefBuilder();
                while (pos < input.length() && Character.isDigit(input.charAt(pos))) {
                    number.append((byte)input.charAt(pos));
                    ++pos;
                }
                int length = pos - start;
                if (length >= 128) {
                    throw new IllegalArgumentException("Groups of digits cannot be longer than 127, but found: " + length);
                }
                result.append((byte)1);
                result.append((byte)(length | 0x80));
                result.append(number);
                if (mainVersionCounter >= 3) continue;
                mainVersionComponents[mainVersionCounter] = Integer.valueOf(number.toBytesRef().utf8ToString());
                ++mainVersionCounter;
                continue;
            }
            result.append((byte)input.charAt(pos));
            ++pos;
        }
        return mainVersionComponents;
    }

    public static BytesRef decodeVersion(BytesRef version) {
        int resultPos = 0;
        byte[] result = new byte[version.length];
        for (int inputPos = version.offset; inputPos < version.offset + version.length; ++inputPos) {
            byte inputByte = version.bytes[inputPos];
            if (inputByte == 1) {
                assert (version.bytes[++inputPos] < 0);
                continue;
            }
            if (inputByte == 2 || inputByte == 3) continue;
            result[resultPos] = inputByte;
            ++resultPos;
        }
        return new BytesRef(result, 0, resultPos);
    }

    static boolean legalVersionString(VersionParts versionParts) {
        boolean legalMainVersion = LEGAL_MAIN_VERSION_SEMVER.matcher(versionParts.mainVersion).matches();
        boolean legalPreRelease = true;
        if (versionParts.preRelease != null) {
            legalPreRelease = LEGAL_PRERELEASE_VERSION_SEMVER.matcher(versionParts.preRelease).matches();
        }
        boolean legalBuildSuffix = true;
        if (versionParts.buildSuffix != null) {
            legalBuildSuffix = LEGAL_BUILDSUFFIX_SEMVER.matcher(versionParts.buildSuffix).matches();
        }
        return legalMainVersion && legalPreRelease && legalBuildSuffix;
    }

    static CompiledAutomaton prefixAutomaton(String versionPrefix, boolean caseInsensitive) {
        Automaton a = new Automaton();
        Automaton.Builder builder = new Automaton.Builder();
        int lastState = builder.createState();
        if (!versionPrefix.isEmpty()) {
            if (caseInsensitive) {
                versionPrefix = versionPrefix.toLowerCase(Locale.ROOT);
            }
            BytesRef bytesRef = new BytesRef((CharSequence)versionPrefix);
            byte[] prefixBytes = bytesRef.bytes;
            for (int i = 0; i < bytesRef.length; ++i) {
                builder.addTransition(lastState, lastState, 3);
                builder.addTransition(lastState, lastState, 2);
                int intermediateState = builder.createState();
                builder.addTransition(lastState, intermediateState, 1);
                builder.addTransition(intermediateState, lastState, 0, 255);
                int state = builder.createState();
                byte b = prefixBytes[i];
                int label = b & 0xFF;
                builder.addTransition(lastState, state, label);
                lastState = state;
            }
        }
        builder.setAccept(lastState, true);
        a = builder.finish();
        assert (!Operations.hasDeadStates((Automaton)a));
        a = Operations.concatenate((Automaton)a, (Automaton)Automata.makeAnyBinary());
        assert (a.isDeterministic());
        a = MinimizationOperations.minimize((Automaton)a, (int)0);
        return new CompiledAutomaton(a, null, true, 0, true);
    }

    static class VersionParts {
        final String mainVersion;
        final String preRelease;
        final String buildSuffix;

        private VersionParts(String mainVersion, String preRelease, String buildSuffix) {
            this.mainVersion = mainVersion;
            this.preRelease = preRelease;
            this.buildSuffix = buildSuffix;
        }

        static VersionParts ofVersion(String versionString) {
            String preRelease;
            String buildSuffix = VersionParts.extractSuffix(versionString, '+');
            if (buildSuffix != null) {
                versionString = versionString.substring(0, versionString.length() - buildSuffix.length());
            }
            if ((preRelease = VersionParts.extractSuffix(versionString, '-')) != null) {
                versionString = versionString.substring(0, versionString.length() - preRelease.length());
            }
            return new VersionParts(versionString, preRelease, buildSuffix);
        }

        private static String extractSuffix(String input, char separator) {
            int start = input.indexOf(separator);
            return start > 0 ? input.substring(start) : null;
        }
    }

    static class EncodedVersion {
        public final boolean isLegal;
        public final boolean isPreRelease;
        public final BytesRef bytesRef;
        public final Integer major;
        public final Integer minor;
        public final Integer patch;

        private EncodedVersion(BytesRef bytesRef, boolean isLegal, boolean isPreRelease, Integer major, Integer minor, Integer patch) {
            this.bytesRef = bytesRef;
            this.isLegal = isLegal;
            this.isPreRelease = isPreRelease;
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }
    }
}

