/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.deprecation.DeprecationChecker;

public class TransformDeprecationChecker
implements DeprecationChecker {
    public static final String TRANSFORM_DEPRECATION_KEY = "transform_settings";

    @Override
    public boolean enabled(Settings settings) {
        return true;
    }

    @Override
    public void check(DeprecationChecker.Components components, ActionListener<DeprecationChecker.CheckResult> deprecationIssueListener) {
        PageParams startPage = new PageParams(0, 100);
        ArrayList<DeprecationIssue> issues = new ArrayList<DeprecationIssue>();
        TransformDeprecationChecker.recursiveGetTransformsAndCollectDeprecations(components, issues, startPage, (ActionListener<List<DeprecationIssue>>)deprecationIssueListener.delegateFailureAndWrap((l, allIssues) -> l.onResponse((Object)new DeprecationChecker.CheckResult(this.getName(), (List<DeprecationIssue>)allIssues))));
    }

    @Override
    public String getName() {
        return TRANSFORM_DEPRECATION_KEY;
    }

    private static void recursiveGetTransformsAndCollectDeprecations(DeprecationChecker.Components components, List<DeprecationIssue> issues, PageParams page, ActionListener<List<DeprecationIssue>> listener) {
        GetTransformAction.Request request = new GetTransformAction.Request("_all");
        request.setPageParams(page);
        request.setAllowNoResources(true);
        components.client().execute((ActionType)GetTransformAction.INSTANCE, (ActionRequest)request, listener.delegateFailureAndWrap((delegate, getTransformResponse) -> {
            for (TransformConfig config : getTransformResponse.getTransformConfigurations()) {
                issues.addAll(config.checkForDeprecations(components.xContentRegistry()));
            }
            if (getTransformResponse.getTransformConfigurationCount() >= (long)(page.getFrom() + page.getSize())) {
                PageParams nextPage = new PageParams(page.getFrom() + page.getSize(), 100);
                TransformDeprecationChecker.recursiveGetTransformsAndCollectDeprecations(components, issues, nextPage, (ActionListener<List<DeprecationIssue>>)delegate);
            } else {
                delegate.onResponse((Object)issues);
            }
        }));
    }
}

