/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.h3.H3;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.GeoPointScriptFieldType;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.spatial.common.H3CartesianUtil;
import org.elasticsearch.xpack.spatial.common.H3SphericalUtil;
import org.elasticsearch.xpack.spatial.index.mapper.GeoShapeWithDocValuesFieldMapper;

public class GeoGridQueryBuilder
extends AbstractQueryBuilder<GeoGridQueryBuilder> {
    public static final String NAME = "geo_grid";
    private static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private Grid grid;
    private String gridId;
    private boolean ignoreUnmapped = false;

    public static Rectangle getQueryTile(String id) {
        Rectangle rectangle = GeoTileUtils.toBoundingBox((String)id);
        int minY = GeoEncodingUtils.encodeLatitude((double)rectangle.getMinLat());
        int minX = GeoEncodingUtils.encodeLongitude((double)rectangle.getMinLon());
        int maxY = GeoEncodingUtils.encodeLatitude((double)rectangle.getMaxLat());
        int maxX = GeoEncodingUtils.encodeLongitude((double)rectangle.getMaxLon());
        return new Rectangle(GeoEncodingUtils.decodeLongitude((int)minX), GeoEncodingUtils.decodeLongitude((int)(maxX == Integer.MAX_VALUE ? maxX : maxX - 1)), GeoEncodingUtils.decodeLatitude((int)maxY), GeoEncodingUtils.decodeLatitude((int)(minY == GeoTileUtils.ENCODED_NEGATIVE_LATITUDE_MASK ? minY : minY + 1)));
    }

    public static Rectangle getQueryHash(String id) {
        Rectangle rectangle = Geohash.toBoundingBox((String)id);
        int minX = GeoEncodingUtils.encodeLongitude((double)rectangle.getMinLon());
        int minY = GeoEncodingUtils.encodeLatitude((double)rectangle.getMinLat());
        int maxX = GeoEncodingUtils.encodeLongitude((double)rectangle.getMaxLon());
        int maxY = GeoEncodingUtils.encodeLatitude((double)rectangle.getMaxLat());
        return new Rectangle(GeoEncodingUtils.decodeLongitude((int)minX), GeoEncodingUtils.decodeLongitude((int)(maxX == Integer.MAX_VALUE ? maxX : maxX - 1)), GeoEncodingUtils.decodeLatitude((int)(maxY == Integer.MAX_VALUE ? maxY : maxY - 1)), GeoEncodingUtils.decodeLatitude((int)minY));
    }

    public GeoGridQueryBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name must not be empty.");
        }
        this.fieldName = fieldName;
    }

    public GeoGridQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.grid = Grid.fromName(in.readString());
        this.gridId = in.readString();
        this.ignoreUnmapped = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeString(this.grid.getName());
        out.writeString(this.gridId);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public GeoGridQueryBuilder setGridId(Grid grid, String gridId) {
        grid.validate(gridId);
        this.grid = grid;
        this.gridId = gridId;
        return this;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoGridQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    public Query doToQuery(SearchExecutionContext context) {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException((QueryRewriteContext)context, "failed to find geo field [" + this.fieldName + "]", new Object[0]);
        }
        return this.grid.toQuery(context, this.fieldName, fieldType, this.gridId);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(this.grid.getName(), this.gridId);
        builder.endObject();
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    public static GeoGridQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        boolean ignoreUnmapped = false;
        Grid grid = null;
        String gridId = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        if (grid != null) {
                            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", new Object[]{NAME, parser.currentName()});
                        }
                        grid = Grid.fromName(parser.currentName());
                        if (parser.nextToken().isValue()) {
                            gridId = parser.text();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", new Object[]{NAME, parser.currentName()});
                    }
                    throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", new Object[]{NAME, currentFieldName});
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", new Object[]{NAME, currentFieldName});
        }
        if (grid == null) {
            throw new ElasticsearchParseException("failed to parse [{}] query. grid name not provided", new Object[]{NAME});
        }
        if (gridId == null) {
            throw new ElasticsearchParseException("failed to parse [{}] query. grid id not provided", new Object[]{NAME});
        }
        GeoGridQueryBuilder builder = new GeoGridQueryBuilder(fieldName);
        builder.setGridId(grid, gridId);
        builder.queryName(queryName);
        builder.boost(boost);
        builder.ignoreUnmapped(ignoreUnmapped);
        return builder;
    }

    protected boolean doEquals(GeoGridQueryBuilder other) {
        return Objects.equals((Object)this.grid, (Object)other.grid) && Objects.equals(this.gridId, other.gridId) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    protected int doHashCode() {
        return Objects.hash(new Object[]{this.grid, this.gridId, this.fieldName, this.ignoreUnmapped});
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_3_0;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Grid {
        GEOHASH{
            private static final String name = "geohash";

            @Override
            protected Query toQuery(SearchExecutionContext context, String fieldName, MappedFieldType fieldType, String id) {
                if (fieldType instanceof GeoShapeQueryable) {
                    GeoShapeQueryable geoShapeQueryable = (GeoShapeQueryable)fieldType;
                    return geoShapeQueryable.geoShapeQuery(context, fieldName, ShapeRelation.INTERSECTS, (Geometry)GeoGridQueryBuilder.getQueryHash(id));
                }
                throw new QueryShardException((QueryRewriteContext)context, "Field [" + fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [geo_grid] query", new Object[0]);
            }

            @Override
            protected String getName() {
                return name;
            }

            @Override
            protected void validate(String gridId) {
                Geohash.mortonEncode((String)gridId);
            }
        }
        ,
        GEOTILE{
            private static final String name = "geotile";

            @Override
            protected Query toQuery(SearchExecutionContext context, String fieldName, MappedFieldType fieldType, String id) {
                if (fieldType instanceof GeoShapeQueryable) {
                    GeoShapeQueryable geoShapeQueryable = (GeoShapeQueryable)fieldType;
                    return geoShapeQueryable.geoShapeQuery(context, fieldName, ShapeRelation.INTERSECTS, (Geometry)GeoGridQueryBuilder.getQueryTile(id));
                }
                throw new QueryShardException((QueryRewriteContext)context, "Field [" + fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [geo_grid] query", new Object[0]);
            }

            @Override
            protected String getName() {
                return name;
            }

            @Override
            protected void validate(String gridId) {
                GeoTileUtils.longEncode((String)gridId);
            }
        }
        ,
        GEOHEX{
            private static final String name = "geohex";

            @Override
            protected Query toQuery(SearchExecutionContext context, String fieldName, MappedFieldType fieldType, String id) {
                long h3 = H3.stringToH3((String)id);
                if (fieldType instanceof GeoShapeWithDocValuesFieldMapper.GeoShapeWithDocValuesFieldType) {
                    GeoShapeWithDocValuesFieldMapper.GeoShapeWithDocValuesFieldType geoShapeFieldType = (GeoShapeWithDocValuesFieldMapper.GeoShapeWithDocValuesFieldType)fieldType;
                    LatLonGeometry geometry = H3CartesianUtil.getLatLonGeometry(h3);
                    return geoShapeFieldType.geoShapeQuery(context, fieldName, ShapeRelation.INTERSECTS, geometry);
                }
                LatLonGeometry geometry = H3SphericalUtil.getLatLonGeometry(h3);
                if (fieldType instanceof GeoPointFieldMapper.GeoPointFieldType) {
                    GeoPointFieldMapper.GeoPointFieldType pointFieldType = (GeoPointFieldMapper.GeoPointFieldType)fieldType;
                    return pointFieldType.geoShapeQuery(context, fieldName, ShapeRelation.INTERSECTS, new LatLonGeometry[]{geometry});
                }
                if (fieldType instanceof GeoPointScriptFieldType) {
                    GeoPointScriptFieldType scriptType = (GeoPointScriptFieldType)fieldType;
                    return scriptType.geoShapeQuery(context, fieldName, ShapeRelation.INTERSECTS, new LatLonGeometry[]{geometry});
                }
                throw new QueryShardException((QueryRewriteContext)context, "Field [" + fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [geo_grid] query", new Object[0]);
            }

            @Override
            protected String getName() {
                return name;
            }

            @Override
            protected void validate(String gridId) {
                boolean valid;
                try {
                    valid = H3.h3IsValid((String)gridId);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid h3 address [" + gridId + "]", e);
                }
                if (!valid) {
                    throw new IllegalArgumentException("Invalid h3 address [" + gridId + "]");
                }
            }
        };


        protected abstract Query toQuery(SearchExecutionContext var1, String var2, MappedFieldType var3, String var4);

        protected abstract String getName();

        protected abstract void validate(String var1);

        private static Grid fromName(String name) {
            if (GEOHEX.getName().equals(name)) {
                return GEOHEX;
            }
            if (GEOTILE.getName().equals(name)) {
                return GEOTILE;
            }
            if (GEOHASH.getName().equals(name)) {
                return GEOHASH;
            }
            throw new ElasticsearchParseException("failed to parse [{}] query. Invalid grid name [" + name + "]", new Object[]{GeoGridQueryBuilder.NAME});
        }
    }
}

