/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.xcontent.XContentParser;

class ShapeParser
extends AbstractGeometryFieldMapper.Parser<Geometry> {
    private final GeometryParser geometryParser;

    ShapeParser(GeometryParser geometryParser) {
        this.geometryParser = geometryParser;
    }

    public void parse(XContentParser parser, CheckedConsumer<Geometry, IOException> consumer, Consumer<Exception> onMalformed) throws IOException {
        try {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    this.parse(parser, consumer, onMalformed);
                }
            } else {
                consumer.accept((Object)this.geometryParser.parse(parser));
            }
        }
        catch (IllegalArgumentException | ParseException | ElasticsearchParseException e) {
            onMalformed.accept((Exception)e);
        }
    }

    public Geometry normalizeFromSource(Geometry geometry) {
        return geometry;
    }
}

