/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.UpgradeTransformsAction;

@ServerlessScope(value=Scope.INTERNAL)
public class RestUpgradeTransformsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_transform/_upgrade"));
    }

    public String getName() {
        return "transform_upgrade_transforms_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        if (restRequest.hasContent()) {
            throw new IllegalArgumentException("upgrade does not allow a request body");
        }
        boolean dryRun = restRequest.paramAsBoolean(TransformField.DRY_RUN.getPreferredName(), false);
        TimeValue timeout = restRequest.paramAsTime(TransformField.TIMEOUT.getPreferredName(), AcknowledgedRequest.DEFAULT_ACK_TIMEOUT);
        return channel -> client.execute((ActionType)UpgradeTransformsAction.INSTANCE, (ActionRequest)new UpgradeTransformsAction.Request(dryRun, timeout), (ActionListener)new RestToXContentListener(channel));
    }
}

