/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.profiling.action.NumberUtils;

final class TopNFunction
implements Cloneable,
ToXContentObject,
Comparable<TopNFunction> {
    private final String id;
    private int rank;
    private final int frameType;
    private final boolean inline;
    private final int addressOrLine;
    private final String functionName;
    private final String sourceFilename;
    private final int sourceLine;
    private final String exeFilename;
    private long selfCount;
    private long totalCount;
    private double selfAnnualCO2Tons;
    private double totalAnnualCO2Tons;
    private double selfAnnualCostsUSD;
    private double totalAnnualCostsUSD;
    private final Map<String, Long> subGroups;

    TopNFunction(String id, int frameType, boolean inline, int addressOrLine, String functionName, String sourceFilename, int sourceLine, String exeFilename) {
        this(id, 0, frameType, inline, addressOrLine, functionName, sourceFilename, sourceLine, exeFilename, 0L, 0L, 0.0, 0.0, 0.0, 0.0, new HashMap<String, Long>());
    }

    TopNFunction(String id, int rank, int frameType, boolean inline, int addressOrLine, String functionName, String sourceFilename, int sourceLine, String exeFilename, long selfCount, long totalCount, double selfAnnualCO2Tons, double totalAnnualCO2Tons, double selfAnnualCostsUSD, double totalAnnualCostsUSD, Map<String, Long> subGroups) {
        this.id = id;
        this.rank = rank;
        this.frameType = frameType;
        this.inline = inline;
        this.addressOrLine = addressOrLine;
        this.functionName = functionName;
        this.sourceFilename = sourceFilename;
        this.sourceLine = sourceLine;
        this.exeFilename = exeFilename;
        this.selfCount = selfCount;
        this.totalCount = totalCount;
        this.selfAnnualCO2Tons = selfAnnualCO2Tons;
        this.totalAnnualCO2Tons = totalAnnualCO2Tons;
        this.selfAnnualCostsUSD = selfAnnualCostsUSD;
        this.totalAnnualCostsUSD = totalAnnualCostsUSD;
        this.subGroups = subGroups;
    }

    public String getId() {
        return this.id;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public long getSelfCount() {
        return this.selfCount;
    }

    public void addSelfCount(long selfCount) {
        this.selfCount += selfCount;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void addTotalCount(long totalCount) {
        this.totalCount += totalCount;
    }

    public double getSelfAnnualCO2Tons() {
        return this.selfAnnualCO2Tons;
    }

    public void addSelfAnnualCO2Tons(double co2Tons) {
        this.selfAnnualCO2Tons += co2Tons;
    }

    public void addTotalAnnualCO2Tons(double co2Tons) {
        this.totalAnnualCO2Tons += co2Tons;
    }

    public double getSelfAnnualCostsUSD() {
        return this.selfAnnualCostsUSD;
    }

    public void addSelfAnnualCostsUSD(double costs) {
        this.selfAnnualCostsUSD += costs;
    }

    public void addTotalAnnualCostsUSD(double costs) {
        this.totalAnnualCostsUSD += costs;
    }

    public void addSubGroups(Map<String, Long> subGroups) {
        for (Map.Entry<String, Long> subGroup : subGroups.entrySet()) {
            long count = this.subGroups.getOrDefault(subGroup.getKey(), 0L);
            this.subGroups.put(subGroup.getKey(), count + subGroup.getValue());
        }
    }

    protected TopNFunction clone() {
        return new TopNFunction(this.id, this.rank, this.frameType, this.inline, this.addressOrLine, this.functionName, this.sourceFilename, this.sourceLine, this.exeFilename, this.selfCount, this.totalCount, this.selfAnnualCO2Tons, this.totalAnnualCO2Tons, this.selfAnnualCostsUSD, this.totalAnnualCostsUSD, new HashMap<String, Long>(this.subGroups));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("rank", this.rank);
        builder.startObject("frame");
        builder.field("frame_type", this.frameType);
        builder.field("inline", this.inline);
        builder.field("address_or_line", this.addressOrLine);
        builder.field("function_name", this.functionName);
        builder.field("file_name", this.sourceFilename);
        builder.field("line_number", this.sourceLine);
        builder.field("executable_file_name", this.exeFilename);
        builder.endObject();
        builder.field("sub_groups", this.subGroups);
        builder.field("self_count", this.selfCount);
        builder.field("total_count", this.totalCount);
        builder.field("self_annual_co2_tons").rawValue(NumberUtils.doubleToString(this.selfAnnualCO2Tons));
        builder.field("total_annual_co2_tons").rawValue(NumberUtils.doubleToString(this.totalAnnualCO2Tons));
        builder.field("self_annual_costs_usd").rawValue(NumberUtils.doubleToString(this.selfAnnualCostsUSD));
        builder.field("total_annual_costs_usd").rawValue(NumberUtils.doubleToString(this.totalAnnualCostsUSD));
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopNFunction that = (TopNFunction)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.rank, that.rank) && Objects.equals(this.frameType, that.frameType) && Objects.equals(this.inline, that.inline) && Objects.equals(this.addressOrLine, that.addressOrLine) && Objects.equals(this.functionName, that.functionName) && Objects.equals(this.sourceFilename, that.sourceFilename) && Objects.equals(this.sourceLine, that.sourceLine) && Objects.equals(this.exeFilename, that.exeFilename) && Objects.equals(this.selfCount, that.selfCount) && Objects.equals(this.totalCount, that.totalCount) && Objects.equals(this.selfAnnualCO2Tons, that.selfAnnualCO2Tons) && Objects.equals(this.totalAnnualCO2Tons, that.totalAnnualCO2Tons) && Objects.equals(this.selfAnnualCostsUSD, that.selfAnnualCostsUSD) && Objects.equals(this.totalAnnualCostsUSD, that.totalAnnualCostsUSD) && Objects.equals(this.subGroups, that.subGroups);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rank, this.frameType, this.inline, this.addressOrLine, this.functionName, this.sourceFilename, this.sourceLine, this.exeFilename, this.selfCount, this.totalCount, this.selfAnnualCO2Tons, this.totalAnnualCO2Tons, this.selfAnnualCostsUSD, this.totalAnnualCostsUSD, this.subGroups);
    }

    public String toString() {
        return "TopNFunction{id='" + this.id + "', rank=" + this.rank + ", frameType=" + this.frameType + ", inline=" + this.inline + ", addressOrLine=" + this.addressOrLine + ", functionName='" + this.functionName + "', sourceFilename='" + this.sourceFilename + "', sourceLine=" + this.sourceLine + ", exeFilename='" + this.exeFilename + "', selfCount=" + this.selfCount + ", totalCount=" + this.totalCount + ", selfAnnualCO2Tons=" + this.selfAnnualCO2Tons + ", totalAnnualCO2Tons=" + this.totalAnnualCO2Tons + ", selfAnnualCostsUSD=" + this.selfAnnualCostsUSD + ", totalAnnualCostsUSD=" + this.totalAnnualCostsUSD + ", subGroups=" + this.subGroups + "}";
    }

    @Override
    public int compareTo(TopNFunction that) {
        if (this.selfCount > that.selfCount) {
            return 1;
        }
        if (this.selfCount < that.selfCount) {
            return -1;
        }
        return this.id.compareTo(that.id);
    }
}

