/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.profiling.action.InstanceType;

final class HostMetadata
implements ToXContentObject {
    static final int DEFAULT_PROFILING_NUM_CORES = 4;
    final String hostID;
    final InstanceType instanceType;
    final String hostArchitecture;
    final int profilingNumCores;

    HostMetadata(String hostID, InstanceType instanceType, String hostArchitecture, Integer profilingNumCores) {
        this.hostID = hostID;
        this.instanceType = instanceType;
        this.hostArchitecture = hostArchitecture;
        this.profilingNumCores = profilingNumCores != null ? profilingNumCores : 4;
    }

    public static HostMetadata fromSource(Map<String, Object> source) {
        if (source != null) {
            String hostID = (String)source.get("host.id");
            String hostArchitecture = (String)source.get("host.arch");
            if (hostArchitecture == null) {
                hostArchitecture = (String)source.get("profiling.host.machine");
            }
            Integer profilingNumCores = (Integer)source.get("profiling.agent.config.present_cpu_cores");
            return new HostMetadata(hostID, InstanceType.fromHostSource(source), hostArchitecture, profilingNumCores);
        }
        return new HostMetadata("", new InstanceType("", "", ""), "", null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.instanceType.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostMetadata that = (HostMetadata)o;
        return Objects.equals(this.hostID, that.hostID);
    }

    public int hashCode() {
        return Objects.hash(this.hostID);
    }
}

