/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetStatusAction
extends ActionType<Response> {
    public static final GetStatusAction INSTANCE = new GetStatusAction();
    public static final String NAME = "cluster:monitor/profiling/status/get";

    protected GetStatusAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private boolean waitForResourcesCreated;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.waitForResourcesCreated = in.readBoolean();
        }

        public Request() {
        }

        public boolean waitForResourcesCreated() {
            return this.waitForResourcesCreated;
        }

        public void waitForResourcesCreated(boolean waitForResourcesCreated) {
            this.waitForResourcesCreated = waitForResourcesCreated;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.waitForResourcesCreated);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final boolean profilingEnabled;
        private final boolean resourceManagementEnabled;
        private final boolean resourcesCreated;
        private final boolean pre891Data;
        private final boolean hasData;
        private boolean timedOut;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.profilingEnabled = in.readBoolean();
            this.resourceManagementEnabled = in.readBoolean();
            this.resourcesCreated = in.readBoolean();
            this.pre891Data = in.readBoolean();
            this.timedOut = in.readBoolean();
            this.hasData = in.readBoolean();
        }

        public Response(boolean profilingEnabled, boolean resourceManagementEnabled, boolean resourcesCreated, boolean pre891Data, boolean hasData) {
            this.profilingEnabled = profilingEnabled;
            this.resourceManagementEnabled = resourceManagementEnabled;
            this.resourcesCreated = resourcesCreated;
            this.pre891Data = pre891Data;
            this.hasData = hasData;
        }

        public void setTimedOut(boolean timedOut) {
            this.timedOut = timedOut;
        }

        public boolean isResourcesCreated() {
            return this.resourcesCreated;
        }

        public boolean hasData() {
            return this.hasData;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("profiling").field("enabled", this.profilingEnabled).endObject();
            builder.startObject("resource_management").field("enabled", this.resourceManagementEnabled).endObject();
            builder.startObject("resources").field("created", this.resourcesCreated).field("pre_8_9_1_data", this.pre891Data).field("has_data", this.hasData).endObject();
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.profilingEnabled);
            out.writeBoolean(this.resourceManagementEnabled);
            out.writeBoolean(this.resourcesCreated);
            out.writeBoolean(this.pre891Data);
            out.writeBoolean(this.timedOut);
            out.writeBoolean(this.hasData);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.profilingEnabled == response.profilingEnabled && this.resourceManagementEnabled == response.resourceManagementEnabled && this.resourcesCreated == response.resourcesCreated && this.pre891Data == response.pre891Data && this.hasData == response.hasData && this.timedOut == response.timedOut;
        }

        public int hashCode() {
            return Objects.hash(this.profilingEnabled, this.resourceManagementEnabled, this.resourcesCreated, this.pre891Data, this.hasData, this.timedOut);
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }

        public RestStatus status() {
            return this.timedOut ? RestStatus.REQUEST_TIMEOUT : RestStatus.OK;
        }
    }
}

