/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.profiling.persistence.EventsIndex;

public class GetStackTracesRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField SAMPLE_SIZE_FIELD = new ParseField("sample_size", new String[0]);
    public static final ParseField LIMIT_FIELD = new ParseField("limit", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField STACKTRACE_IDS_FIELD = new ParseField("stacktrace_ids_field", new String[0]);
    public static final ParseField AGGREGATION_FIELD = new ParseField("aggregation_field", new String[0]);
    public static final ParseField REQUESTED_DURATION_FIELD = new ParseField("requested_duration", new String[0]);
    public static final ParseField AWS_COST_FACTOR_FIELD = new ParseField("aws_cost_factor", new String[0]);
    public static final ParseField AZURE_COST_FACTOR_FIELD = new ParseField("azure_cost_factor", new String[0]);
    public static final ParseField CUSTOM_CO2_PER_KWH = new ParseField("co2_per_kwh", new String[0]);
    public static final ParseField CUSTOM_DATACENTER_PUE = new ParseField("datacenter_pue", new String[0]);
    public static final ParseField CUSTOM_PER_CORE_WATT_X86 = new ParseField("per_core_watt_x86", new String[0]);
    public static final ParseField CUSTOM_PER_CORE_WATT_ARM64 = new ParseField("per_core_watt_arm64", new String[0]);
    public static final ParseField CUSTOM_COST_PER_CORE_HOUR = new ParseField("cost_per_core_hour", new String[0]);
    private static final int DEFAULT_SAMPLE_SIZE = 20000;
    private QueryBuilder query;
    private int sampleSize;
    private Integer limit;
    private String[] indices;
    private boolean userProvidedIndices;
    private String stackTraceIdsField;
    private String aggregationField;
    private Double requestedDuration;
    private Double awsCostFactor;
    private Double azureCostFactor;
    private Double customCO2PerKWH;
    private Double customDatacenterPUE;
    private Double customPerCoreWattX86;
    private Double customPerCoreWattARM64;
    private Double customCostPerCoreHour;
    private Boolean adjustSampleCount;
    private Integer shardSeed;

    public GetStackTracesRequest() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public GetStackTracesRequest(Integer sampleSize, Double requestedDuration, Double awsCostFactor, Double azureCostFactor, QueryBuilder query, String[] indices, String stackTraceIdsField, String aggregationField, Double customCO2PerKWH, Double customDatacenterPUE, Double customPerCoreWattX86, Double customPerCoreWattARM64, Double customCostPerCoreHour) {
        this.sampleSize = sampleSize != null ? sampleSize : 20000;
        this.requestedDuration = requestedDuration;
        this.awsCostFactor = awsCostFactor;
        this.azureCostFactor = azureCostFactor;
        this.query = query;
        this.indices = indices;
        this.userProvidedIndices = indices != null && indices.length > 0;
        this.stackTraceIdsField = stackTraceIdsField;
        this.aggregationField = aggregationField;
        this.customCO2PerKWH = customCO2PerKWH;
        this.customDatacenterPUE = customDatacenterPUE;
        this.customPerCoreWattX86 = customPerCoreWattX86;
        this.customPerCoreWattARM64 = customPerCoreWattARM64;
        this.customCostPerCoreHour = customCostPerCoreHour;
    }

    public void writeTo(StreamOutput out) {
        TransportAction.localOnly();
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Double getRequestedDuration() {
        return this.requestedDuration;
    }

    public Double getAwsCostFactor() {
        return this.awsCostFactor;
    }

    public Double getAzureCostFactor() {
        return this.azureCostFactor;
    }

    public Double getCustomCO2PerKWH() {
        return this.customCO2PerKWH;
    }

    public Double getCustomDatacenterPUE() {
        return this.customDatacenterPUE;
    }

    public Double getCustomPerCoreWattX86() {
        return this.customPerCoreWattX86;
    }

    public Double getCustomPerCoreWattARM64() {
        return this.customPerCoreWattARM64;
    }

    public Double getCustomCostPerCoreHour() {
        return this.customCostPerCoreHour;
    }

    public QueryBuilder getQuery() {
        return this.query;
    }

    public String[] getIndices() {
        return this.indices;
    }

    public boolean isUserProvidedIndices() {
        return this.userProvidedIndices;
    }

    public String getStackTraceIdsField() {
        return this.stackTraceIdsField;
    }

    public String getAggregationField() {
        return this.aggregationField;
    }

    public boolean isAdjustSampleCount() {
        return Boolean.TRUE.equals(this.adjustSampleCount);
    }

    public void setAdjustSampleCount(Boolean adjustSampleCount) {
        this.adjustSampleCount = adjustSampleCount;
    }

    public Integer getShardSeed() {
        return this.shardSeed;
    }

    public void setShardSeed(Integer shardSeed) {
        this.shardSeed = shardSeed;
    }

    public void parseXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        if (token != XContentParser.Token.START_OBJECT && (token = parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [" + XContentParser.Token.START_OBJECT + "] but found [" + token + "].", new Object[0]);
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SAMPLE_SIZE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.sampleSize = parser.intValue();
                    continue;
                }
                if (LIMIT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.limit = parser.intValue();
                    continue;
                }
                if (STACKTRACE_IDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.stackTraceIdsField = parser.text();
                    continue;
                }
                if (AGGREGATION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.aggregationField = parser.text();
                    continue;
                }
                if (REQUESTED_DURATION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.requestedDuration = parser.doubleValue();
                    continue;
                }
                if (AWS_COST_FACTOR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.awsCostFactor = parser.doubleValue();
                    continue;
                }
                if (AZURE_COST_FACTOR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.azureCostFactor = parser.doubleValue();
                    continue;
                }
                if (CUSTOM_CO2_PER_KWH.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.customCO2PerKWH = parser.doubleValue();
                    continue;
                }
                if (CUSTOM_DATACENTER_PUE.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.customDatacenterPUE = parser.doubleValue();
                    continue;
                }
                if (CUSTOM_PER_CORE_WATT_X86.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.customPerCoreWattX86 = parser.doubleValue();
                    continue;
                }
                if (CUSTOM_PER_CORE_WATT_ARM64.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.customPerCoreWattARM64 = parser.doubleValue();
                    continue;
                }
                if (CUSTOM_COST_PER_CORE_HOUR.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.customCostPerCoreHour = parser.doubleValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
                this.query = AbstractQueryBuilder.parseTopLevelQuery((XContentParser)parser);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (INDICES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.indices = this.parseIndices(parser);
                    this.userProvidedIndices = true;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", new Object[0]);
        }
        token = parser.nextToken();
        if (token != null) {
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token [" + token + "] found after the main object.", new Object[0]);
        }
    }

    private String[] parseIndices(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<String> indices = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.VALUE_STRING) {
                indices.add(parser.text());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Expected [" + XContentParser.Token.VALUE_STRING + "] but found [" + token + "] in [" + INDICES_FIELD.getPreferredName() + "].", new Object[0]);
        }
        return indices.toArray(new String[0]);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.userProvidedIndices) {
            if (this.stackTraceIdsField == null || this.stackTraceIdsField.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)("[" + STACKTRACE_IDS_FIELD.getPreferredName() + "] is mandatory"), validationException);
            }
        } else if (this.stackTraceIdsField != null) {
            validationException = ValidateActions.addValidationError((String)("[" + STACKTRACE_IDS_FIELD.getPreferredName() + "] must not be set"), validationException);
        }
        if (this.aggregationField != null && this.aggregationField.isBlank()) {
            validationException = ValidateActions.addValidationError((String)("[" + AGGREGATION_FIELD.getPreferredName() + "] must be non-empty"), (ActionRequestValidationException)validationException);
        }
        validationException = GetStackTracesRequest.requirePositive(SAMPLE_SIZE_FIELD, this.sampleSize, validationException);
        validationException = GetStackTracesRequest.requirePositive(LIMIT_FIELD, this.limit, validationException);
        validationException = GetStackTracesRequest.requirePositive(REQUESTED_DURATION_FIELD, this.requestedDuration, validationException);
        validationException = GetStackTracesRequest.requirePositive(AWS_COST_FACTOR_FIELD, this.awsCostFactor, validationException);
        validationException = GetStackTracesRequest.requirePositive(AZURE_COST_FACTOR_FIELD, this.azureCostFactor, validationException);
        validationException = GetStackTracesRequest.requirePositive(CUSTOM_CO2_PER_KWH, this.customCO2PerKWH, validationException);
        validationException = GetStackTracesRequest.requirePositive(CUSTOM_DATACENTER_PUE, this.customDatacenterPUE, validationException);
        validationException = GetStackTracesRequest.requirePositive(CUSTOM_PER_CORE_WATT_X86, this.customPerCoreWattX86, validationException);
        validationException = GetStackTracesRequest.requirePositive(CUSTOM_PER_CORE_WATT_ARM64, this.customPerCoreWattARM64, validationException);
        validationException = GetStackTracesRequest.requirePositive(CUSTOM_COST_PER_CORE_HOUR, this.customCostPerCoreHour, validationException);
        return validationException;
    }

    private static ActionRequestValidationException requirePositive(ParseField field, Number value, ActionRequestValidationException e) {
        if (value != null && value.doubleValue() <= 0.0) {
            return ValidateActions.addValidationError((String)("[" + field.getPreferredName() + "] must be greater than 0, got: " + value), (ActionRequestValidationException)e);
        }
        return e;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, null, parentTaskId, headers){

            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                GetStackTracesRequest.appendField(sb, "indices", GetStackTracesRequest.this.indices);
                GetStackTracesRequest.appendField(sb, "stacktrace_ids_field", GetStackTracesRequest.this.stackTraceIdsField);
                GetStackTracesRequest.appendField(sb, "aggregation_field", GetStackTracesRequest.this.aggregationField);
                GetStackTracesRequest.appendField(sb, "sample_size", GetStackTracesRequest.this.sampleSize);
                GetStackTracesRequest.appendField(sb, "limit", GetStackTracesRequest.this.limit);
                GetStackTracesRequest.appendField(sb, "requested_duration", GetStackTracesRequest.this.requestedDuration);
                GetStackTracesRequest.appendField(sb, "aws_cost_factor", GetStackTracesRequest.this.awsCostFactor);
                GetStackTracesRequest.appendField(sb, "azure_cost_factor", GetStackTracesRequest.this.azureCostFactor);
                GetStackTracesRequest.appendField(sb, "co2_per_kwh", GetStackTracesRequest.this.customCO2PerKWH);
                GetStackTracesRequest.appendField(sb, "datacenter_pue", GetStackTracesRequest.this.customDatacenterPUE);
                GetStackTracesRequest.appendField(sb, "per_core_watt_x86", GetStackTracesRequest.this.customPerCoreWattX86);
                GetStackTracesRequest.appendField(sb, "per_core_watt_arm64", GetStackTracesRequest.this.customPerCoreWattARM64);
                GetStackTracesRequest.appendField(sb, "cost_per_core_hour", GetStackTracesRequest.this.customCostPerCoreHour);
                GetStackTracesRequest.appendField(sb, "query", GetStackTracesRequest.this.query);
                return sb.toString();
            }
        };
    }

    private static void appendField(StringBuilder sb, String name, Object value) {
        if (!sb.isEmpty()) {
            sb.append(", ");
        }
        if (value == null) {
            sb.append(name).append("[]");
        } else {
            sb.append(name).append("[").append(value).append("]");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetStackTracesRequest that = (GetStackTracesRequest)((Object)o);
        return Objects.equals(this.query, that.query) && Objects.equals(this.sampleSize, that.sampleSize) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.stackTraceIdsField, that.stackTraceIdsField);
    }

    public int hashCode() {
        return Objects.hash(Objects.toString(this.query, "null"), this.sampleSize, Arrays.hashCode(this.indices), this.stackTraceIdsField);
    }

    public String[] indices() {
        HashSet<String> indices = new HashSet<String>();
        indices.add("profiling-stacktraces");
        indices.add("profiling-stackframes");
        indices.add("profiling-executables");
        if (this.userProvidedIndices) {
            indices.addAll(List.of(this.indices));
        } else {
            indices.addAll(EventsIndex.indexNames());
        }
        return indices.toArray(new String[0]);
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.STRICT_EXPAND_OPEN;
    }

    public boolean includeDataStreams() {
        return true;
    }

    public IndicesRequest indices(String ... indices) {
        GetStackTracesRequest.validateIndices(indices);
        this.indices = indices;
        return null;
    }

    private static void validateIndices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
    }
}

