/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.LongAsyncCounter;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

public class LongAsyncCounterAdapter
extends AbstractInstrument<ObservableLongCounter>
implements LongAsyncCounter {
    public LongAsyncCounterAdapter(Meter meter, String name, String description, String unit, Supplier<LongWithAttributes> observer) {
        super(meter, new Builder(name, description, unit, observer));
    }

    public void close() throws Exception {
        ((ObservableLongCounter)this.getInstrument()).close();
    }

    private static class Builder
    extends AbstractInstrument.Builder<ObservableLongCounter> {
        private final Supplier<LongWithAttributes> observer;

        private Builder(String name, String description, String unit, Supplier<LongWithAttributes> observer) {
            super(name, description, unit);
            this.observer = Objects.requireNonNull(observer);
        }

        @Override
        public ObservableLongCounter build(Meter meter) {
            return Objects.requireNonNull(meter).counterBuilder(this.name).setDescription(this.description).setUnit(this.unit).buildWithCallback(OtelHelper.longMeasurementCallback(this.observer));
        }
    }
}

