/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.DoubleGauge;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;

public class DoubleGaugeAdapter
extends AbstractInstrument<ObservableDoubleGauge>
implements DoubleGauge {
    public DoubleGaugeAdapter(Meter meter, String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
        super(meter, new Builder(name, description, unit, observer));
    }

    public void close() throws Exception {
        ((ObservableDoubleGauge)this.getInstrument()).close();
    }

    private static class Builder
    extends AbstractInstrument.Builder<ObservableDoubleGauge> {
        private final Supplier<DoubleWithAttributes> observer;

        private Builder(String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
            super(name, description, unit);
            this.observer = Objects.requireNonNull(observer);
        }

        @Override
        public ObservableDoubleGauge build(Meter meter) {
            return Objects.requireNonNull(meter).gaugeBuilder(this.name).setDescription(this.description).setUnit(this.unit).buildWithCallback(OtelHelper.doubleMeasurementCallback(this.observer));
        }
    }
}

