/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.TransportException;

public class ActionTransportException
extends TransportException {
    public ActionTransportException(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_1_0)) {
            in.readOptionalWriteable(TransportAddress::new);
            in.readOptionalString();
        }
    }

    public ActionTransportException(String name, TransportAddress address, String action, Throwable cause) {
        this(name, address, action, null, cause);
    }

    public ActionTransportException(String name, TransportAddress address, String action, String msg, Throwable cause) {
        this(name, address == null ? null : address.address(), action, msg, cause);
    }

    public ActionTransportException(String name, InetSocketAddress address, String action, String msg, Throwable cause) {
        super(ActionTransportException.buildMessage(name, address, action, msg), cause);
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        if (out.getTransportVersion().before(TransportVersions.V_8_1_0)) {
            out.writeMissingWriteable(TransportAddress.class);
            out.writeMissingString();
        }
    }

    private static String buildMessage(String name, InetSocketAddress address, String action, String msg) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append('[').append(name).append(']');
        }
        if (address != null) {
            sb.append('[').append(NetworkAddress.format(address)).append(']');
        }
        if (action != null) {
            sb.append('[').append(action).append(']');
        }
        if (msg != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }
}

