/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.DelayableWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.SimpleRefCounted;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.RescoreDocIds;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.SearchProfileDfsPhaseResult;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.rank.RankShardResult;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.transport.LeakTracker;

public final class QuerySearchResult
extends SearchPhaseResult {
    private int from;
    private int size;
    private TopDocsAndMaxScore topDocsAndMaxScore;
    private boolean hasScoreDocs;
    private RankShardResult rankShardResult;
    private TotalHits totalHits;
    private float maxScore = Float.NaN;
    private DocValueFormat[] sortValueFormats;
    private DelayableWriteable<InternalAggregations> aggregations;
    private boolean hasAggs;
    private Suggest suggest;
    private boolean searchTimedOut;
    private Boolean terminatedEarly = null;
    private SearchProfileQueryPhaseResult profileShardResults;
    private boolean hasProfileResults;
    private long serviceTimeEWMA = -1L;
    private int nodeQueueSize = -1;
    private final boolean isNull;
    private final RefCounted refCounted;
    private final List<Releasable> toRelease;

    public QuerySearchResult() {
        this(false);
    }

    public QuerySearchResult(StreamInput in) throws IOException {
        this(in, false);
    }

    public QuerySearchResult(StreamInput in, boolean delayedAggregations) throws IOException {
        super(in);
        this.isNull = in.readBoolean();
        if (!this.isNull) {
            ShardSearchContextId id = new ShardSearchContextId(in);
            this.readFromWithId(id, in, delayedAggregations);
        }
        this.refCounted = null;
        this.toRelease = null;
    }

    public QuerySearchResult(ShardSearchContextId contextId, SearchShardTarget shardTarget, ShardSearchRequest shardSearchRequest) {
        this.contextId = contextId;
        this.setSearchShardTarget(shardTarget);
        this.isNull = false;
        this.setShardSearchRequest(shardSearchRequest);
        this.toRelease = new ArrayList<Releasable>();
        this.refCounted = LeakTracker.wrap((RefCounted)new SimpleRefCounted());
    }

    private QuerySearchResult(boolean isNull) {
        this.isNull = isNull;
        this.refCounted = null;
        this.toRelease = null;
    }

    public static QuerySearchResult nullInstance() {
        return new QuerySearchResult(true);
    }

    public boolean isNull() {
        return this.isNull;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this;
    }

    public void searchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public boolean searchTimedOut() {
        return this.searchTimedOut;
    }

    public void terminatedEarly(boolean terminatedEarly) {
        this.terminatedEarly = terminatedEarly;
    }

    @Nullable
    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public TopDocsAndMaxScore topDocs() {
        if (this.topDocsAndMaxScore == null) {
            throw new IllegalStateException("topDocs already consumed");
        }
        return this.topDocsAndMaxScore;
    }

    public boolean hasConsumedTopDocs() {
        return this.topDocsAndMaxScore == null;
    }

    public TopDocsAndMaxScore consumeTopDocs() {
        TopDocsAndMaxScore topDocsAndMaxScore = this.topDocsAndMaxScore;
        if (topDocsAndMaxScore == null) {
            throw new IllegalStateException("topDocs already consumed");
        }
        this.topDocsAndMaxScore = null;
        return topDocsAndMaxScore;
    }

    public void topDocs(TopDocsAndMaxScore topDocs, DocValueFormat[] sortValueFormats) {
        int numFields;
        this.setTopDocs(topDocs);
        if (topDocs.topDocs.scoreDocs.length > 0 && topDocs.topDocs.scoreDocs[0] instanceof FieldDoc && (numFields = ((FieldDoc)topDocs.topDocs.scoreDocs[0]).fields.length) != sortValueFormats.length) {
            throw new IllegalArgumentException("The number of sort fields does not match: " + numFields + " != " + sortValueFormats.length);
        }
        this.sortValueFormats = sortValueFormats;
    }

    private void setTopDocs(TopDocsAndMaxScore topDocsAndMaxScore) {
        this.topDocsAndMaxScore = topDocsAndMaxScore;
        this.totalHits = topDocsAndMaxScore.topDocs.totalHits;
        this.maxScore = topDocsAndMaxScore.maxScore;
        this.hasScoreDocs = topDocsAndMaxScore.topDocs.scoreDocs.length > 0;
    }

    public void setRankShardResult(RankShardResult rankShardResult) {
        this.rankShardResult = rankShardResult;
    }

    @Nullable
    public RankShardResult getRankShardResult() {
        return this.rankShardResult;
    }

    @Nullable
    public DocValueFormat[] sortValueFormats() {
        return this.sortValueFormats;
    }

    public boolean hasAggs() {
        return this.hasAggs;
    }

    public DelayableWriteable<InternalAggregations> getAggs() {
        if (this.aggregations == null) {
            throw new IllegalStateException("aggs already released");
        }
        return this.aggregations;
    }

    public void releaseAggs() {
        if (this.aggregations != null) {
            this.aggregations.close();
            this.aggregations = null;
        }
    }

    public void addReleasable(Releasable releasable) {
        this.toRelease.add(releasable);
    }

    public void aggregations(InternalAggregations aggregations) {
        assert (this.aggregations == null) : "aggregations already set to [" + this.aggregations + "]";
        this.aggregations = aggregations == null ? null : DelayableWriteable.referencing(aggregations);
        this.hasAggs = aggregations != null;
    }

    @Nullable
    public DelayableWriteable<InternalAggregations> aggregations() {
        return this.aggregations;
    }

    public void setSearchProfileDfsPhaseResult(SearchProfileDfsPhaseResult searchProfileDfsPhaseResult) {
        if (this.profileShardResults == null) {
            return;
        }
        this.profileShardResults.setSearchProfileDfsPhaseResult(searchProfileDfsPhaseResult);
    }

    public SearchProfileQueryPhaseResult consumeProfileResult() {
        if (this.profileShardResults == null) {
            throw new IllegalStateException("profile results already consumed");
        }
        SearchProfileQueryPhaseResult result = this.profileShardResults;
        this.profileShardResults = null;
        return result;
    }

    public boolean hasProfileResults() {
        return this.hasProfileResults;
    }

    public void consumeAll() {
        if (this.hasProfileResults()) {
            this.consumeProfileResult();
        }
        if (!this.hasConsumedTopDocs()) {
            this.consumeTopDocs();
        }
        this.releaseAggs();
    }

    public void profileResults(SearchProfileQueryPhaseResult shardResults) {
        this.profileShardResults = shardResults;
        this.hasProfileResults = shardResults != null;
    }

    public Suggest suggest() {
        return this.suggest;
    }

    public void suggest(Suggest suggest) {
        this.suggest = suggest;
    }

    public int from() {
        return this.from;
    }

    public QuerySearchResult from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public QuerySearchResult size(int size) {
        this.size = size;
        return this;
    }

    public long serviceTimeEWMA() {
        return this.serviceTimeEWMA;
    }

    public QuerySearchResult serviceTimeEWMA(long serviceTimeEWMA) {
        this.serviceTimeEWMA = serviceTimeEWMA;
        return this;
    }

    public int nodeQueueSize() {
        return this.nodeQueueSize;
    }

    public QuerySearchResult nodeQueueSize(int nodeQueueSize) {
        this.nodeQueueSize = nodeQueueSize;
        return this;
    }

    public boolean hasSuggestHits() {
        return this.suggest != null && this.suggest.hasScoreDocs();
    }

    public boolean hasSearchContext() {
        return this.hasScoreDocs || this.hasSuggestHits() || this.rankShardResult != null;
    }

    public void readFromWithId(ShardSearchContextId id, StreamInput in) throws IOException {
        this.readFromWithId(id, in, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromWithId(ShardSearchContextId id, StreamInput in, boolean delayedAggregations) throws IOException {
        this.contextId = id;
        this.from = in.readVInt();
        this.size = in.readVInt();
        int numSortFieldsPlus1 = in.readVInt();
        if (numSortFieldsPlus1 == 0) {
            this.sortValueFormats = null;
        } else {
            this.sortValueFormats = new DocValueFormat[numSortFieldsPlus1 - 1];
            for (int i = 0; i < this.sortValueFormats.length; ++i) {
                this.sortValueFormats[i] = in.readNamedWriteable(DocValueFormat.class);
            }
        }
        this.setTopDocs(Lucene.readTopDocs(in));
        this.hasAggs = in.readBoolean();
        boolean success = false;
        try {
            if (this.hasAggs) {
                this.aggregations = delayedAggregations ? DelayableWriteable.delayed(InternalAggregations::readFrom, in) : DelayableWriteable.referencing(InternalAggregations::readFrom, in);
            }
            if (in.readBoolean()) {
                this.suggest = new Suggest(in);
            }
            this.searchTimedOut = in.readBoolean();
            this.terminatedEarly = in.readOptionalBoolean();
            this.profileShardResults = in.readOptionalWriteable(SearchProfileQueryPhaseResult::new);
            this.hasProfileResults = this.profileShardResults != null;
            this.serviceTimeEWMA = in.readZLong();
            this.nodeQueueSize = in.readInt();
            this.setShardSearchRequest(in.readOptionalWriteable(ShardSearchRequest::new));
            this.setRescoreDocIds(new RescoreDocIds(in));
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
                this.rankShardResult = in.readOptionalNamedWriteable(RankShardResult.class);
            }
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close(this.aggregations);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.aggregations != null && this.aggregations.isSerialized()) {
            throw new IllegalStateException("cannot send serialized version since it will leak");
        }
        out.writeBoolean(this.isNull);
        if (!this.isNull) {
            this.contextId.writeTo(out);
            this.writeToNoId(out);
        }
    }

    public void writeToNoId(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        if (this.sortValueFormats == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(1 + this.sortValueFormats.length);
            for (int i = 0; i < this.sortValueFormats.length; ++i) {
                out.writeNamedWriteable(this.sortValueFormats[i]);
            }
        }
        Lucene.writeTopDocs(out, this.topDocsAndMaxScore);
        out.writeOptionalWriteable(this.aggregations);
        if (this.suggest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.suggest.writeTo(out);
        }
        out.writeBoolean(this.searchTimedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileShardResults);
        out.writeZLong(this.serviceTimeEWMA);
        out.writeInt(this.nodeQueueSize);
        out.writeOptionalWriteable(this.getShardSearchRequest());
        this.getRescoreDocIds().writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeOptionalNamedWriteable(this.rankShardResult);
        } else if (this.rankShardResult != null) {
            throw new IllegalArgumentException("cannot serialize [rank] to version [" + out.getTransportVersion().toReleaseVersion() + "]");
        }
    }

    @Nullable
    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    @Override
    public void incRef() {
        if (this.refCounted != null) {
            this.refCounted.incRef();
        } else {
            super.incRef();
        }
    }

    @Override
    public boolean tryIncRef() {
        if (this.refCounted != null) {
            return this.refCounted.tryIncRef();
        }
        return super.tryIncRef();
    }

    @Override
    public boolean decRef() {
        if (this.refCounted != null) {
            if (this.refCounted.decRef()) {
                Releasables.close(this.toRelease);
                return true;
            }
            return false;
        }
        return super.decRef();
    }

    @Override
    public boolean hasReferences() {
        if (this.refCounted != null) {
            return this.refCounted.hasReferences();
        }
        return super.hasReferences();
    }
}

