/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

public class LeafSearchLookup {
    private int doc;
    private final LeafDocLookup docMap;
    private final LeafStoredFieldsLookup fieldsLookup;
    private final Map<String, Object> asMap;
    private final Supplier<Source> source;

    public LeafSearchLookup(LeafReaderContext ctx, LeafDocLookup docMap, SourceProvider sourceProvider, LeafStoredFieldsLookup fieldsLookup) {
        this.docMap = docMap;
        this.fieldsLookup = fieldsLookup;
        this.source = () -> {
            try {
                return sourceProvider.getSource(ctx, this.doc);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Couldn't load source", e);
            }
        };
        this.asMap = Map.of("doc", docMap, "_doc", docMap, "_source", this.source, "_fields", fieldsLookup);
    }

    public Map<String, Object> asMap() {
        return this.asMap;
    }

    public LeafStoredFieldsLookup fields() {
        return this.fieldsLookup;
    }

    public LeafDocLookup doc() {
        return this.docMap;
    }

    public Supplier<Source> source() {
        return this.source;
    }

    public void setDocument(int docId) {
        this.doc = docId;
        this.docMap.setDocument(docId);
        this.fieldsLookup.setDocument(docId);
    }
}

