/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;

public final class LimitTokenOffsetAnalyzer
extends AnalyzerWrapper {
    private final Analyzer delegate;
    private final int maxOffset;

    public LimitTokenOffsetAnalyzer(Analyzer delegate, int maxOffset) {
        super(delegate.getReuseStrategy());
        this.delegate = delegate;
        this.maxOffset = maxOffset;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.delegate;
    }

    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)new LimitTokenOffsetFilter(components.getTokenStream(), this.maxOffset, false));
    }

    public String toString() {
        return "LimitTokenOffsetAnalyzer(" + this.delegate.toString() + ", maxOffset=" + this.maxOffset + ")";
    }
}

