/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.TDigest;

public class TDigestState {
    private final double compression;
    private final TDigest tdigest;
    private final Type type;

    public static TDigestState create(double compression) {
        return new TDigestState(Type.defaultValue(), compression);
    }

    public static TDigestState createOptimizedForAccuracy(double compression) {
        return new TDigestState(Type.valueForHighAccuracy(), compression);
    }

    public static TDigestState create(double compression, TDigestExecutionHint executionHint) {
        return switch (executionHint) {
            default -> throw new IncompatibleClassChangeError();
            case TDigestExecutionHint.HIGH_ACCURACY -> TDigestState.createOptimizedForAccuracy(compression);
            case TDigestExecutionHint.DEFAULT -> TDigestState.create(compression);
        };
    }

    public static TDigestState createUsingParamsFrom(TDigestState state) {
        return new TDigestState(state.type, state.compression);
    }

    protected TDigestState(Type type, double compression) {
        this.tdigest = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.HYBRID -> TDigest.createHybridDigest((double)compression);
            case Type.AVL_TREE -> TDigest.createAvlTreeDigest((double)compression);
            case Type.SORTING -> TDigest.createSortingDigest();
            case Type.MERGING -> TDigest.createMergingDigest((double)compression);
        };
        this.type = type;
        this.compression = compression;
    }

    public final double compression() {
        return this.compression;
    }

    public static void write(TDigestState state, StreamOutput out) throws IOException {
        out.writeDouble(state.compression);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeString(state.type.toString());
            out.writeVLong(state.tdigest.size());
        }
        out.writeVInt(state.centroidCount());
        for (Centroid centroid : state.centroids()) {
            out.writeDouble(centroid.mean());
            out.writeVLong(centroid.count());
        }
    }

    public static TDigestState read(StreamInput in) throws IOException {
        TDigestState state;
        double compression = in.readDouble();
        long size = 0L;
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            state = new TDigestState(Type.valueOf(in.readString()), compression);
            size = in.readVLong();
        } else {
            state = new TDigestState(Type.valueForHighAccuracy(), compression);
        }
        int n = in.readVInt();
        if (size > 0L) {
            state.tdigest.reserve(size);
        }
        for (int i = 0; i < n; ++i) {
            state.add(in.readDouble(), in.readVLong());
        }
        return state;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TDigestState)) {
            return false;
        }
        TDigestState that = (TDigestState)obj;
        if (this == that) {
            return true;
        }
        if (this.compression != that.compression) {
            return false;
        }
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        if (this.getMax() != that.getMax()) {
            return false;
        }
        if (this.getMin() != that.getMin()) {
            return false;
        }
        if (this.centroidCount() != that.centroidCount()) {
            return false;
        }
        Iterator<Centroid> thisCentroids = this.centroids().iterator();
        Iterator<Centroid> thatCentroids = that.centroids().iterator();
        while (thisCentroids.hasNext()) {
            if (!thatCentroids.hasNext()) {
                return false;
            }
            Centroid thisNext = thisCentroids.next();
            Centroid thatNext = thatCentroids.next();
            if (thisNext.mean() == thatNext.mean() && thisNext.count() == thatNext.count()) continue;
            return false;
        }
        return !thatCentroids.hasNext();
    }

    public int hashCode() {
        int h = 31 * Double.hashCode(this.compression) + this.type.hashCode();
        h = 31 * h + Integer.hashCode(this.centroidCount());
        for (Centroid centroid : this.centroids()) {
            h = 31 * h + Double.hashCode(centroid.mean());
            h = 31 * h + (int)centroid.count();
        }
        h = 31 * h + Double.hashCode(this.getMax());
        h = 31 * h + Double.hashCode(this.getMin());
        return h;
    }

    public void add(TDigestState other) {
        this.tdigest.add(other.tdigest);
    }

    public void add(double x, long w) {
        this.tdigest.add(x, w);
    }

    public void add(double x) {
        this.tdigest.add(x, 1L);
    }

    public final void compress() {
        this.tdigest.compress();
    }

    public final long size() {
        return this.tdigest.size();
    }

    public final double cdf(double x) {
        return this.tdigest.cdf(x);
    }

    public final double quantile(double q) {
        return this.tdigest.quantile(q);
    }

    public final Collection<Centroid> centroids() {
        return this.tdigest.centroids();
    }

    public final int centroidCount() {
        return this.tdigest.centroidCount();
    }

    public final double getMin() {
        return this.tdigest.getMin();
    }

    public final double getMax() {
        return this.tdigest.getMax();
    }

    protected static enum Type {
        HYBRID,
        AVL_TREE,
        MERGING,
        SORTING;


        static Type defaultValue() {
            return HYBRID;
        }

        static Type valueForHighAccuracy() {
            return AVL_TREE;
        }
    }
}

