/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

abstract class AbstractTDigestPercentilesAggregator
extends NumericMetricsAggregator.MultiValue {
    protected final double[] keys;
    protected final ValuesSource valuesSource;
    protected final DocValueFormat formatter;
    protected ObjectArray<TDigestState> states;
    protected final double compression;
    protected final TDigestExecutionHint executionHint;
    protected final boolean keyed;

    AbstractTDigestPercentilesAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] keys, double compression, TDigestExecutionHint executionHint, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = config.getValuesSource();
        this.keyed = keyed;
        this.formatter = formatter;
        this.states = context.bigArrays().newObjectArray(1L);
        this.keys = keys;
        this.compression = compression;
        this.executionHint = executionHint;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues values = ((ValuesSource.Numeric)this.valuesSource).doubleValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                TDigestState state = AbstractTDigestPercentilesAggregator.this.getExistingOrNewHistogram(AbstractTDigestPercentilesAggregator.this.bigArrays(), bucket);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    for (int i = 0; i < valueCount; ++i) {
                        state.add(values.nextValue());
                    }
                }
            }
        };
    }

    private TDigestState getExistingOrNewHistogram(BigArrays bigArrays, long bucket) {
        this.states = bigArrays.grow(this.states, bucket + 1L);
        TDigestState state = this.states.get(bucket);
        if (state == null) {
            state = TDigestState.create(this.compression, this.executionHint);
            this.states.set(bucket, state);
        }
        return state;
    }

    @Override
    public boolean hasMetric(String name) {
        return PercentilesConfig.indexOfKey(this.keys, Double.parseDouble(name)) >= 0;
    }

    protected TDigestState getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        return this.states.get(bucketOrd);
    }

    @Override
    protected void doClose() {
        Releasables.close(this.states);
    }
}

