/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;

public class GeoHashBoundedPredicate {
    private final boolean crossesDateline;
    private final long maxHashes;
    private final GeoBoundingBox bbox;

    public GeoHashBoundedPredicate(int precision, GeoBoundingBox bbox) {
        long hashesX;
        this.crossesDateline = bbox.right() < bbox.left();
        this.bbox = bbox;
        long hashesY = (long)Math.ceil((bbox.top() - bbox.bottom()) / Geohash.latHeightInDegrees((int)precision) + 1.0);
        if (this.crossesDateline) {
            long hashesLeft = (long)Math.ceil((180.0 - bbox.left()) / Geohash.lonWidthInDegrees((int)precision) + 1.0);
            long hashesRight = (long)Math.ceil((bbox.right() + 180.0) / Geohash.lonWidthInDegrees((int)precision) + 1.0);
            hashesX = hashesLeft + hashesRight;
        } else {
            hashesX = (long)Math.ceil((bbox.right() - bbox.left()) / Geohash.lonWidthInDegrees((int)precision) + 1.0);
        }
        this.maxHashes = hashesX * hashesY;
    }

    public boolean validHash(String geohash) {
        Rectangle rect = Geohash.toBoundingBox((String)geohash);
        if (rect.getMaxX() < rect.getMinX()) {
            return this.intersects(-180.0, rect.getMaxX(), rect.getMinY(), rect.getMaxY()) || this.intersects(rect.getMinX(), 180.0, rect.getMinY(), rect.getMaxY());
        }
        return this.intersects(rect.getMinX(), rect.getMaxX(), rect.getMinY(), rect.getMaxY());
    }

    private boolean intersects(double minX, double maxX, double minY, double maxY) {
        if (this.bbox.top() > minY && this.bbox.bottom() < maxY) {
            if (this.crossesDateline) {
                return this.bbox.left() < maxX || this.bbox.right() > minX;
            }
            return this.bbox.left() < maxX && this.bbox.right() > minX;
        }
        return false;
    }

    public long getMaxHashes() {
        return this.maxHashes;
    }
}

