/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public abstract class ChunkedBlobOutputStream<T>
extends OutputStream {
    protected final List<T> parts = new ArrayList<T>();
    private final long maxBytesToBuffer;
    private final BigArrays bigArrays;
    protected ReleasableBytesStreamOutput buffer;
    protected boolean successful = false;
    private boolean closed = false;
    protected long flushedBytes = 0L;

    protected ChunkedBlobOutputStream(BigArrays bigArrays, long maxBytesToBuffer) {
        this.bigArrays = bigArrays;
        if (maxBytesToBuffer <= 0L) {
            throw new IllegalArgumentException("maximum buffer size must be positive");
        }
        this.maxBytesToBuffer = maxBytesToBuffer;
        this.buffer = new ReleasableBytesStreamOutput(bigArrays);
    }

    @Override
    public final void write(int b) throws IOException {
        this.buffer.write(b);
        this.maybeFlushBuffer();
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
        this.maybeFlushBuffer();
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            assert (false) : "this output stream should only be closed once";
            throw new AlreadyClosedException("already closed");
        }
        this.closed = true;
        try {
            if (this.successful) {
                this.onCompletion();
            } else {
                this.onFailure();
            }
        }
        finally {
            Releasables.close((Releasable)this.buffer);
        }
    }

    public final void markSuccess() {
        this.successful = true;
    }

    protected final void finishPart(T partId) {
        this.flushedBytes += (long)this.buffer.size();
        this.parts.add(partId);
        this.buffer.close();
        this.buffer = this.successful ? null : new ReleasableBytesStreamOutput(this.bigArrays);
    }

    protected abstract void flushBuffer() throws IOException;

    protected abstract void onCompletion() throws IOException;

    protected abstract void onFailure();

    private void maybeFlushBuffer() throws IOException {
        if ((long)this.buffer.size() >= this.maxBytesToBuffer) {
            this.flushBuffer();
        }
    }
}

