/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.repositories.ShardGeneration;

public class ShardSnapshotResult
implements Writeable {
    private final ShardGeneration generation;
    private final ByteSizeValue size;
    private final int segmentCount;

    public ShardSnapshotResult(ShardGeneration generation, ByteSizeValue size, int segmentCount) {
        this.generation = Objects.requireNonNull(generation);
        this.size = Objects.requireNonNull(size);
        assert (segmentCount >= 0);
        this.segmentCount = segmentCount;
    }

    public ShardSnapshotResult(StreamInput in) throws IOException {
        this.generation = new ShardGeneration(in);
        this.size = ByteSizeValue.readFrom(in);
        this.segmentCount = in.readVInt();
    }

    public ShardGeneration getGeneration() {
        return this.generation;
    }

    public ByteSizeValue getSize() {
        return this.size;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.generation.writeTo(out);
        this.size.writeTo(out);
        out.writeVInt(this.segmentCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSnapshotResult that = (ShardSnapshotResult)o;
        return this.segmentCount == that.segmentCount && this.generation.equals(that.generation) && this.size.equals(that.size);
    }

    public int hashCode() {
        return Objects.hash(this.generation, this.size, this.segmentCount);
    }

    public String toString() {
        return "ShardSnapshotResult{generation='" + this.generation + "', size=" + this.size + ", segmentCount=" + this.segmentCount + "}";
    }
}

