/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TaskType implements Writeable
{
    TEXT_EMBEDDING,
    SPARSE_EMBEDDING,
    RERANK,
    COMPLETION,
    ANY{

        @Override
        public boolean isAnyOrSame(TaskType other) {
            return true;
        }
    };

    public static String NAME;

    public static TaskType fromString(String name) {
        return TaskType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static TaskType fromStringOrStatusException(String name) {
        try {
            TaskType taskType = TaskType.fromString(name);
            return Objects.requireNonNull(taskType);
        }
        catch (IllegalArgumentException e) {
            throw new ElasticsearchStatusException("Unknown task_type [{}]", RestStatus.BAD_REQUEST, name);
        }
    }

    public boolean isAnyOrSame(TaskType other) {
        return other == ANY || other == this;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static TaskType fromStream(StreamInput in) throws IOException {
        return in.readEnum(TaskType.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static String unsupportedTaskTypeErrorMsg(TaskType taskType, String serviceName) {
        return "The [" + serviceName + "] service does not support task type [" + taskType + "]";
    }

    static {
        NAME = "task_type";
    }
}

