/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class StatelessPrimaryRelocationAction {
    public static final ActionType<ActionResponse.Empty> TYPE = new ActionType("internal:index/shard/recovery/stateless_primary_relocation");

    public static class Request
    extends ActionRequest {
        private final long recoveryId;
        private final ShardId shardId;
        private final DiscoveryNode targetNode;
        private final String targetAllocationId;
        private final long clusterStateVersion;

        public Request(long recoveryId, ShardId shardId, DiscoveryNode targetNode, String targetAllocationId, long clusterStateVersion) {
            this.recoveryId = recoveryId;
            this.shardId = shardId;
            this.targetNode = targetNode;
            this.targetAllocationId = targetAllocationId;
            this.clusterStateVersion = clusterStateVersion;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.recoveryId = in.readVLong();
            this.shardId = new ShardId(in);
            this.targetNode = new DiscoveryNode(in);
            this.targetAllocationId = in.readString();
            this.clusterStateVersion = in.readVLong();
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.recoveryId);
            this.shardId.writeTo(out);
            this.targetNode.writeTo(out);
            out.writeString(this.targetAllocationId);
            out.writeVLong(this.clusterStateVersion);
        }

        public long recoveryId() {
            return this.recoveryId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public DiscoveryNode targetNode() {
            return this.targetNode;
        }

        public String targetAllocationId() {
            return this.targetAllocationId;
        }

        public long clusterStateVersion() {
            return this.clusterStateVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.recoveryId == request.recoveryId && this.shardId.equals(request.shardId) && this.targetNode.equals(request.targetNode) && this.targetAllocationId.equals(request.targetAllocationId) && this.clusterStateVersion == request.clusterStateVersion;
        }

        public int hashCode() {
            return Objects.hash(this.recoveryId, this.shardId, this.targetNode, this.targetAllocationId, this.clusterStateVersion);
        }
    }
}

